/*
 * Decompiled with CFR 0.152.
 */
package pethorses.storage.database;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import pethorses.PetHorses;
import pethorses.config.ConfigManager;
import pethorses.storage.HorseData;
import pethorses.storage.StorageStrategy;
import pethorses.storage.database.DatabaseManager;
import pethorses.storage.database.HorseDataRepository;
import pethorses.storage.database.PassengerRepository;

public class DatabaseStorage
implements StorageStrategy {
    private final DatabaseManager dbManager;
    private final HorseDataRepository horseRepo;
    private final PassengerRepository passengerRepo;
    private final Map<UUID, HorseData> horsesData = new ConcurrentHashMap<UUID, HorseData>();
    private final Map<UUID, Set<UUID>> passengerPermissions = new ConcurrentHashMap<UUID, Set<UUID>>();

    public DatabaseStorage(PetHorses plugin, ConfigManager configManager) {
        Logger logger = plugin.getLogger();
        this.dbManager = new DatabaseManager(configManager);
        this.horseRepo = new HorseDataRepository(this.dbManager, logger);
        this.passengerRepo = new PassengerRepository(this.dbManager, logger);
        this.loadData();
    }

    @Override
    public void loadData() {
        this.horsesData.clear();
        this.horsesData.putAll(this.horseRepo.loadAll());
        this.passengerPermissions.clear();
        this.passengerPermissions.putAll(this.passengerRepo.loadAll());
    }

    @Override
    public HorseData getHorseData(UUID playerId) {
        return this.horsesData.computeIfAbsent(playerId, k -> {
            HorseData hd = new HorseData();
            hd.setOwnerId(playerId);
            return hd;
        });
    }

    @Override
    public void saveHorseData(HorseData data) {
        if (data.getOwnerId() == null) {
            System.err.println("Attempted to save HorseData with null ownerId. Skipping save.");
            return;
        }
        this.horsesData.put(data.getOwnerId(), data);
        this.horseRepo.save(data);
    }

    @Override
    public void saveAllData() {
        this.horsesData.values().forEach(hd -> {
            if (hd != null && hd.getOwnerId() != null) {
                this.horseRepo.save((HorseData)hd);
            } else {
                System.err.println("Skipping save for HorseData with null ownerId.");
            }
        });
    }

    @Override
    public Set<UUID> getPassengers(UUID ownerUUID) {
        return this.passengerPermissions.getOrDefault(ownerUUID, Collections.emptySet());
    }

    @Override
    public void addPassenger(UUID ownerUUID, UUID passengerUUID) {
        this.passengerPermissions.computeIfAbsent(ownerUUID, k -> ConcurrentHashMap.newKeySet()).add(passengerUUID);
        this.passengerRepo.addPassenger(ownerUUID, passengerUUID);
    }

    @Override
    public void removePassenger(UUID ownerUUID, UUID passengerUUID) {
        Set<UUID> passengers = this.passengerPermissions.get(ownerUUID);
        if (passengers != null) {
            passengers.remove(passengerUUID);
        }
        this.passengerRepo.removePassenger(ownerUUID, passengerUUID);
    }

    public void close() {
        this.dbManager.close();
    }

    public Set<UUID> getAllPlayerIds() {
        return this.horsesData.keySet();
    }
}

