/*
 * Decompiled with CFR 0.152.
 */
package pethorses.storage.yaml;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import pethorses.PetHorses;
import pethorses.storage.HorseData;
import pethorses.storage.StorageStrategy;
import pethorses.storage.yaml.YamlHorseDataRepository;
import pethorses.storage.yaml.YamlPassengerRepository;

public class YamlStorage
implements StorageStrategy {
    private final Logger logger;
    private final File dataFile;
    private final FileConfiguration dataConfig;
    private final YamlHorseDataRepository horseRepo;
    private final YamlPassengerRepository passengerRepo;
    private final Map<UUID, HorseData> horsesData;
    private final Map<UUID, Set<UUID>> passengerPermissions;
    private final Object fileLock = new Object();

    public YamlStorage(PetHorses plugin) {
        this.logger = plugin.getLogger();
        File candidate = new File(plugin.getDataFolder(), "horses_data.yml");
        File parent = candidate.getParentFile();
        boolean parentOk = false;
        if (parent != null) {
            if (parent.exists()) {
                parentOk = true;
            } else {
                try {
                    parentOk = parent.mkdirs();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        if (!parentOk) {
            File alt = new File(System.getProperty("java.io.tmpdir"), "PetHorses-" + System.currentTimeMillis());
            try {
                if (alt.mkdirs()) {
                    parentOk = true;
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (parentOk) {
                this.dataFile = new File(alt, "horses_data.yml");
                this.logger.warning("Using system temp directory for horse data: " + this.dataFile.getAbsolutePath());
            } else {
                this.dataFile = candidate;
                this.logger.severe("Failed to create plugin data directory and temp fallback; writes may fail: " + candidate.getAbsolutePath());
            }
        } else {
            this.dataFile = candidate;
        }
        this.logger.fine("Horse data file path set to: " + this.dataFile.getAbsolutePath());
        if (!this.dataFile.exists()) {
            try {
                boolean created = this.dataFile.createNewFile();
                if (!created) {
                    this.logger.warning("Data file could not be created or already exists: " + this.dataFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                this.logger.severe("Failed to create data file: " + e.getMessage());
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        this.horseRepo = new YamlHorseDataRepository(this.dataConfig);
        this.passengerRepo = new YamlPassengerRepository(this.dataConfig);
        this.horsesData = new ConcurrentHashMap<UUID, HorseData>();
        this.passengerPermissions = new ConcurrentHashMap<UUID, Set<UUID>>();
    }

    @Override
    public void loadData() {
        this.horsesData.clear();
        this.passengerPermissions.clear();
        for (String key : this.dataConfig.getKeys(false)) {
            try {
                UUID playerId = UUID.fromString(key);
                this.horsesData.put(playerId, this.horseRepo.load(playerId));
                this.passengerPermissions.put(playerId, this.passengerRepo.load(playerId));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Override
    public HorseData getHorseData(UUID playerId) {
        return this.horsesData.computeIfAbsent(playerId, k -> {
            HorseData hd = new HorseData();
            hd.setOwnerId(playerId);
            return hd;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveHorseData(HorseData data) {
        if (data.getOwnerId() == null) {
            this.logger.warning("Attempted to save HorseData with null ownerId. Skipping save.");
            return;
        }
        Object object = this.fileLock;
        synchronized (object) {
            this.horseRepo.save(data);
            this.passengerRepo.save(data.getOwnerId(), this.passengerPermissions.getOrDefault(data.getOwnerId(), Collections.emptySet()));
            this.saveToFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAllData() {
        Object object = this.fileLock;
        synchronized (object) {
            for (String string : this.dataConfig.getKeys(false)) {
                this.dataConfig.set(string, null);
            }
            for (Map.Entry entry : this.horsesData.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null || ((HorseData)entry.getValue()).getOwnerId() == null) {
                    this.logger.warning("Skipping save for horse with null ownerId or HorseData.");
                    continue;
                }
                this.horseRepo.save((HorseData)entry.getValue());
                this.passengerRepo.save((UUID)entry.getKey(), this.passengerPermissions.getOrDefault(entry.getKey(), Collections.emptySet()));
            }
            this.saveToFile();
        }
    }

    private void saveToFile() {
        String content;
        Path targetPath = this.dataFile.toPath();
        Path parentPath = targetPath.getParent();
        int attempts = 0;
        while (attempts < 3) {
            try {
                if (parentPath == null) break;
                Files.createDirectories(parentPath, new FileAttribute[0]);
                break;
            }
            catch (IOException e) {
                this.logger.warning("Attempt " + ++attempts + " to create parent directories failed: " + e.getMessage());
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (parentPath != null && !Files.exists(parentPath, new LinkOption[0])) {
            this.logger.warning("Parent directory for horse data does not exist after retries: " + String.valueOf(parentPath));
        }
        try {
            content = this.dataConfig.saveToString();
        }
        catch (Throwable t2) {
            this.logger.severe("Failed to serialize YAML content: " + t2.getMessage());
            return;
        }
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        Path tempPath = null;
        Exception lastTempEx = null;
        try {
            Path homeTemp = new File(System.getProperty("user.home"), ".pethorses_temp").toPath();
            try {
                Files.createDirectories(homeTemp, new FileAttribute[0]);
                tempPath = Files.createTempFile(homeTemp, "horses_data-", ".tmp", new FileAttribute[0]);
                Files.write(tempPath, bytes, new OpenOption[0]);
                this.logger.fine("Temp file created in user.home: " + String.valueOf(tempPath));
            }
            catch (Exception e) {
                lastTempEx = e;
                this.logger.fine("Failed to write temp file in user.home: " + e.getMessage());
            }
        }
        catch (Exception e) {
            lastTempEx = e;
            this.logger.fine("Failed to prepare user.home temp dir: " + e.getMessage());
        }
        if (tempPath == null) {
            try {
                Path sysTmp = new File(System.getProperty("java.io.tmpdir")).toPath();
                Files.createDirectories(sysTmp, new FileAttribute[0]);
                tempPath = Files.createTempFile(sysTmp, "horses_data-", ".tmp", new FileAttribute[0]);
                Files.write(tempPath, bytes, new OpenOption[0]);
                this.logger.fine("Temp file created in system tmp: " + String.valueOf(tempPath));
            }
            catch (Exception e) {
                lastTempEx = e;
                this.logger.warning("Writing temp file in java.io.tmpdir failed: " + e.getMessage());
            }
        }
        if (tempPath == null) {
            this.logger.severe("Unable to create any temp file for horse data; aborting save.");
            this.logger.severe("Last temp error: " + String.valueOf(lastTempEx));
            return;
        }
        this.logger.fine("Prepared temp file: " + String.valueOf(tempPath) + ", target: " + String.valueOf(targetPath));
        try {
            try {
                if (parentPath != null) {
                    Files.createDirectories(parentPath, new FileAttribute[0]);
                }
            }
            catch (IOException e) {
                this.logger.fine("Parent dirs create before move failed: " + e.getMessage());
            }
            try {
                Files.move(tempPath, targetPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                this.logger.fine("Atomic move succeeded: " + String.valueOf(targetPath));
                return;
            }
            catch (IOException atomicEx) {
                this.logger.fine("Atomic move failed, will try non-atomic: " + atomicEx.getMessage());
                try {
                    Files.move(tempPath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    this.logger.fine("Non-atomic move succeeded: " + String.valueOf(targetPath));
                    return;
                }
                catch (IOException moveEx2) {
                    this.logger.warning("Non-atomic move failed: " + moveEx2.getMessage());
                    try {
                        Files.write(targetPath, bytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                        this.logger.fine("Wrote directly to target file after move failure: " + String.valueOf(targetPath));
                        try {
                            Files.deleteIfExists(tempPath);
                        }
                        catch (IOException moveEx2) {
                        }
                    }
                    catch (IOException writeEx) {
                        this.logger.severe("Direct write to target failed. temp=" + String.valueOf(tempPath) + " target=" + String.valueOf(targetPath) + " error=" + writeEx.getMessage());
                        try {
                            Files.deleteIfExists(tempPath);
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        catch (Exception ex) {
            this.logger.severe("Unexpected error in saveToFile: " + ex.getMessage());
            try {
                Files.deleteIfExists(tempPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public Set<UUID> getPassengers(UUID ownerUUID) {
        return this.passengerPermissions.getOrDefault(ownerUUID, Collections.emptySet());
    }

    @Override
    public void addPassenger(UUID ownerUUID, UUID passengerUUID) {
        this.passengerPermissions.computeIfAbsent(ownerUUID, k -> Collections.newSetFromMap(new ConcurrentHashMap())).add(passengerUUID);
    }

    @Override
    public void removePassenger(UUID ownerUUID, UUID passengerUUID) {
        this.passengerPermissions.getOrDefault(ownerUUID, Collections.emptySet()).remove(passengerUUID);
    }

    public Set<UUID> getAllPlayerIds() {
        return this.horsesData.keySet();
    }
}

