/*
 * Decompiled with CFR 0.152.
 */
package pethorses.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class TextUtil {
    private static final Map<NamedTextColor, String> COLOR_TO_KEY;
    private static final Map<String, NamedTextColor> KEY_TO_COLOR;

    public static Component colored(NamedTextColor color, String text) {
        return Component.text((String)text).color((TextColor)(color != null ? color : NamedTextColor.WHITE));
    }

    public static Component plain(String text) {
        return Component.text((String)text);
    }

    public static String namedTextColorToKey(NamedTextColor named) {
        if (named == null) {
            return COLOR_TO_KEY.getOrDefault(NamedTextColor.WHITE, "WHITE");
        }
        return COLOR_TO_KEY.getOrDefault(named, "WHITE");
    }

    public static NamedTextColor parseNamedTextColor(String name) {
        if (name == null) {
            return NamedTextColor.WHITE;
        }
        String key = name.trim().toUpperCase();
        return KEY_TO_COLOR.getOrDefault(key, NamedTextColor.WHITE);
    }

    static {
        HashMap<NamedTextColor, String> c2k = new HashMap<NamedTextColor, String>();
        HashMap<String, NamedTextColor> k2c = new HashMap<String, NamedTextColor>();
        try {
            for (Field field : NamedTextColor.class.getFields()) {
                Object val;
                if (!Modifier.isStatic(field.getModifiers()) || field.getType() != NamedTextColor.class || !((val = field.get(null)) instanceof NamedTextColor)) continue;
                NamedTextColor color = (NamedTextColor)val;
                String name = field.getName();
                c2k.put(color, name);
                k2c.put(name.toUpperCase(), color);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        k2c.putIfAbsent("WHITE", NamedTextColor.WHITE);
        c2k.putIfAbsent(NamedTextColor.WHITE, "WHITE");
        COLOR_TO_KEY = Collections.unmodifiableMap(c2k);
        KEY_TO_COLOR = Collections.unmodifiableMap(k2c);
    }
}

