/*
 * Decompiled with CFR 0.152.
 */
package pethorses;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import pethorses.commands.HorseCommandExecutor;
import pethorses.config.ConfigManager;
import pethorses.config.LocalizationManager;
import pethorses.listeners.BackpackInventoryListener;
import pethorses.listeners.ChatInputListener;
import pethorses.listeners.HorseArmorListener;
import pethorses.listeners.HorseBackpackListener;
import pethorses.listeners.HorseEventListener;
import pethorses.listeners.HorseMovementListener;
import pethorses.listeners.HorseStatsMenuListener;
import pethorses.listeners.MenuClickListener;
import pethorses.menus.HorseCustomizationMenu;
import pethorses.services.HorseBackpackService;
import pethorses.services.HorseService;
import pethorses.services.PassengerService;
import pethorses.storage.HorseData;
import pethorses.storage.HorseDataManager;

public class PetHorses
extends JavaPlugin {
    private ConfigManager configManager;
    private LocalizationManager localizationManager;
    private HorseDataManager horseDataManager;
    private HorseService horseService;
    private PassengerService passengerService;
    private ChatInputListener chatInputListener;
    private HorseBackpackService horseBackpackService;

    public void onEnable() {
        this.saveDefaultConfig();
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.initServices();
        this.getCommand("horse").setExecutor((CommandExecutor)new HorseCommandExecutor(this));
        this.registerListeners();
        this.startAutoSaveTask();
        this.getLogger().info(this.localizationManager.getMessage("plugin.enabled"));
    }

    public void onDisable() {
        for (UUID playerId : this.horseDataManager.getAllPlayerIds()) {
            Entity entity;
            HorseData data = this.horseDataManager.getHorseData(playerId);
            if (data != null && data.getHorseId() != null && (entity = Bukkit.getEntity((UUID)data.getHorseId())) instanceof Horse) {
                Horse horse = (Horse)entity;
                for (Entity passenger : horse.getPassengers()) {
                    horse.removePassenger(passenger);
                }
            }
            this.horseService.hideHorse(data);
        }
        this.horseDataManager.saveAllData();
        this.horseDataManager.close();
        this.getLogger().info(this.localizationManager.getMessage("plugin.disabled"));
    }

    private void initServices() {
        this.configManager = new ConfigManager(this);
        this.localizationManager = new LocalizationManager(this);
        this.horseDataManager = new HorseDataManager(this);
        this.horseService = new HorseService(this);
        this.passengerService = new PassengerService(this);
        this.chatInputListener = new ChatInputListener(this);
        this.horseBackpackService = new HorseBackpackService(this);
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new HorseEventListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new HorseMovementListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new HorseStatsMenuListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MenuClickListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new HorseCustomizationMenu(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.chatInputListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new HorseBackpackListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BackpackInventoryListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new HorseArmorListener(this), (Plugin)this);
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public LocalizationManager getLocalizationManager() {
        return this.localizationManager;
    }

    public HorseDataManager getHorseDataManager() {
        return this.horseDataManager;
    }

    public HorseService getHorseService() {
        return this.horseService;
    }

    public PassengerService getPassengerService() {
        return this.passengerService;
    }

    public ChatInputListener getChatInputListener() {
        return this.chatInputListener;
    }

    private void startAutoSaveTask() {
        long interval = 12000L;
        this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
            this.horseDataManager.saveAllData();
            this.getLogger().info(this.localizationManager.getMessage("plugin.autosave"));
        }, interval, interval);
    }
}

