/*
 * Decompiled with CFR 0.152.
 */
package pethorses.commands;

import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Player;
import pethorses.PetHorses;
import pethorses.config.LocalizationManager;
import pethorses.menus.HorseCustomizationMenu;
import pethorses.menus.HorseStatsMenu;
import pethorses.services.HorseService;
import pethorses.services.PassengerService;
import pethorses.storage.HorseData;

public class HorseCommandExecutor
implements CommandExecutor {
    private final PetHorses plugin;
    private final HorseService horseService;
    private final PassengerService passengerService;
    private final LocalizationManager localizationManager;

    public HorseCommandExecutor(PetHorses plugin) {
        this.plugin = plugin;
        this.horseService = plugin.getHorseService();
        this.passengerService = plugin.getPassengerService();
        this.localizationManager = plugin.getLocalizationManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.localizationManager.getMessage("error.players_only"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0 || args[0].equalsIgnoreCase("stats")) {
            HorseStatsMenu.open(player, this.plugin);
            return true;
        }
        HorseData data = this.horseService.getHorseData(player.getUniqueId());
        switch (args[0].toLowerCase()) {
            case "summon": {
                this.horseService.summonHorse(player);
                break;
            }
            case "hide": {
                this.horseService.hideHorse(data);
                player.sendMessage(this.localizationManager.getMessage("horse.hidden"));
                break;
            }
            case "follow": {
                Entity entity;
                this.horseService.setFollowing(data, true);
                if (data.getHorseId() != null && (entity = Bukkit.getEntity((UUID)data.getHorseId())) instanceof Horse) {
                    Horse horse = (Horse)entity;
                    this.horseService.makeHorseFollow(player, data, horse);
                }
                player.sendMessage(this.localizationManager.getMessage("horse.following"));
                break;
            }
            case "stay": {
                this.horseService.setFollowing(data, false);
                player.sendMessage(this.localizationManager.getMessage("horse.staying"));
                break;
            }
            case "customize": {
                HorseCustomizationMenu.open(player, this.plugin);
                break;
            }
            case "allowpassenger": {
                this.handleAllowPassenger(player, args);
                break;
            }
            case "removepassenger": {
                this.handleRemovePassenger(player, args);
                break;
            }
            case "passengers": {
                this.showPassengers(player);
                break;
            }
            case "help": {
                this.sendHelpMessage(player);
                break;
            }
            default: {
                player.sendMessage(this.localizationManager.getMessage("error.unknown_command"));
                this.sendHelpMessage(player);
            }
        }
        return true;
    }

    private void handleAllowPassenger(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(this.localizationManager.getMessage("passenger.usage_allow"));
            return;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            player.sendMessage(this.localizationManager.getMessage("error.player_not_found"));
            return;
        }
        this.passengerService.addPermission(player.getUniqueId(), target.getUniqueId());
        player.sendMessage(this.localizationManager.getMessage("passenger.allowed").replace("{player}", target.getName()));
        target.sendMessage(this.localizationManager.getMessage("passenger.informed_allowed").replace("{owner}", player.getName()));
    }

    private void handleRemovePassenger(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(this.localizationManager.getMessage("passenger.usage_remove"));
            return;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            player.sendMessage(this.localizationManager.getMessage("error.player_not_found"));
            return;
        }
        this.passengerService.removePermission(player.getUniqueId(), target.getUniqueId());
        player.sendMessage(this.localizationManager.getMessage("passenger.removed").replace("{player}", target.getName()));
        target.sendMessage(this.localizationManager.getMessage("passenger.informed_removed").replace("{owner}", player.getName()));
    }

    private void showPassengers(Player player) {
        Set<UUID> passengers = this.passengerService.getPassengers(player.getUniqueId());
        if (passengers.isEmpty()) {
            player.sendMessage(this.localizationManager.getMessage("passenger.list_empty"));
        } else {
            player.sendMessage(this.localizationManager.getMessage("passenger.list_header"));
            for (UUID passengerId : passengers) {
                Player p = Bukkit.getPlayer((UUID)passengerId);
                if (p == null) continue;
                player.sendMessage(this.localizationManager.getMessage("passenger.list_item").replace("{player}", p.getName()));
            }
        }
    }

    private void sendHelpMessage(Player player) {
        player.sendMessage(this.localizationManager.getMessage("help.title"));
        player.sendMessage(this.localizationManager.getMessage("help.stats"));
        player.sendMessage(this.localizationManager.getMessage("help.summon"));
        player.sendMessage(this.localizationManager.getMessage("help.hide"));
        player.sendMessage(this.localizationManager.getMessage("help.follow"));
        player.sendMessage(this.localizationManager.getMessage("help.stay"));
        player.sendMessage(this.localizationManager.getMessage("help.customize"));
        player.sendMessage(this.localizationManager.getMessage("help.allowpassenger"));
        player.sendMessage(this.localizationManager.getMessage("help.removepassenger"));
        player.sendMessage(this.localizationManager.getMessage("help.passengers"));
        player.sendMessage(this.localizationManager.getMessage("help.help"));
    }
}

