/*
 * Decompiled with CFR 0.152.
 */
package pethorses.config;

import org.bukkit.configuration.file.FileConfiguration;
import pethorses.PetHorses;

public class ConfigManager {
    private final PetHorses plugin;
    private FileConfiguration config;

    public ConfigManager(PetHorses plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        this.config.options().copyDefaults(true);
        plugin.saveConfig();
    }

    public String getLanguage() {
        return this.config.getString("language", "en");
    }

    public boolean isDatabaseEnabled() {
        return this.config.getBoolean("database.enabled", false);
    }

    public String getDatabaseHost() {
        return this.config.getString("database.host", "localhost");
    }

    public int getDatabasePort() {
        return this.config.getInt("database.port", 3306);
    }

    public String getDatabaseName() {
        return this.config.getString("database.name", "minecraft");
    }

    public String getDatabaseUser() {
        return this.config.getString("database.user", "root");
    }

    public String getDatabasePassword() {
        return this.config.getString("database.password", "");
    }

    public int getBaseXpForLevel() {
        return this.config.getInt("leveling.base_xp", 100);
    }

    public int getXpIncrementPerLevel() {
        return this.config.getInt("leveling.xp_increment", 50);
    }

    public double getSpeedBase() {
        return this.config.getDouble("stats.speed_base", 0.18);
    }

    public double getSpeedMaxBonus() {
        return this.config.getDouble("stats.speed_max_bonus", 0.225);
    }

    public double getHealthBase() {
        return this.config.getDouble("stats.health_base", 15.0);
    }

    public double getHealthMaxBonus() {
        return this.config.getDouble("stats.health_max_bonus", 15.0);
    }

    public double getJumpBase() {
        return this.config.getDouble("stats.jump_base", 0.6);
    }

    public double getJumpMaxBonus() {
        return this.config.getDouble("stats.jump_max_bonus", 0.6);
    }

    public long getRespawnCooldownMinutes() {
        return this.config.getLong("respawn_cooldown_minutes", 15L);
    }

    public boolean isFallDamageAllowed() {
        return this.config.getBoolean("allow_fall_damage", false);
    }

    public boolean isOtherPlayersDamageHorsesAllowed() {
        return this.config.getBoolean("allow_other_players_damage_horses", false);
    }

    public int getBackpackBaseSize() {
        return this.config.getInt("backpack.base_size", 9);
    }

    public int getBackpackSizePerLevel() {
        return this.config.getInt("backpack.size_per_level", 9);
    }

    public int getBackpackMaxSize() {
        return this.config.getInt("backpack.max_size", 54);
    }

    public boolean isArmorSlotEnabled() {
        return this.config.getBoolean("backpack.armor_slot_enabled", true);
    }

    public boolean isBackpackDropOnDeath() {
        return this.config.getBoolean("backpack.drop_on_death", true);
    }
}

