/*
 * Decompiled with CFR 0.152.
 */
package pethorses.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import pethorses.PetHorses;
import pethorses.config.LocalizationManager;

public class ChatInputListener
implements Listener {
    private final Map<UUID, Consumer<String>> inputCallbacks = new HashMap<UUID, Consumer<String>>();
    private final PetHorses plugin;
    private final LocalizationManager localizationManager;

    public ChatInputListener(PetHorses plugin) {
        this.plugin = plugin;
        this.localizationManager = plugin.getLocalizationManager();
    }

    public void awaitInput(Player player, Consumer<String> callback) {
        this.inputCallbacks.put(player.getUniqueId(), callback);
        player.sendMessage(this.localizationManager.getMessage("input.prompt"));
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (!this.inputCallbacks.containsKey(player.getUniqueId())) {
            return;
        }
        event.setCancelled(true);
        String message = event.getMessage();
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            if (message.equalsIgnoreCase(this.localizationManager.getMessage("input.cancel_keyword"))) {
                player.sendMessage(this.localizationManager.getMessage("input.cancelled"));
            } else {
                this.inputCallbacks.get(player.getUniqueId()).accept(message);
            }
            this.inputCallbacks.remove(player.getUniqueId());
        });
    }
}

