/*
 * Decompiled with CFR 0.152.
 */
package pethorses.listeners;

import java.util.Iterator;
import org.bukkit.Material;
import org.bukkit.entity.Horse;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.HorseInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import pethorses.PetHorses;
import pethorses.services.HorseService;

public class HorseArmorListener
implements Listener {
    private final HorseService horseService;

    public HorseArmorListener(PetHorses plugin) {
        this.horseService = plugin.getHorseService();
    }

    @EventHandler
    public void onHorseInventoryClick(InventoryClickEvent event) {
        Horse horse;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory inventory = event.getInventory();
        if (!(inventory instanceof HorseInventory)) {
            return;
        }
        HorseInventory horseInv = (HorseInventory)inventory;
        InventoryHolder inventoryHolder = horseInv.getHolder();
        if (inventoryHolder instanceof Horse && (horse = (Horse)inventoryHolder).isTamed() && horse.getOwner() != null && horse.getOwner().getUniqueId().equals(player.getUniqueId())) {
            ItemStack armor = horseInv.getArmor();
            this.horseService.saveHorseArmor(player.getUniqueId(), armor);
            ItemStack current = event.getCurrentItem();
            if (current != null && current.getType() != Material.AIR) {
                boolean isSaddle;
                boolean bl = isSaddle = current.getType() == Material.SADDLE;
                if (isSaddle) {
                    if (event.isShiftClick()) {
                        event.setCancelled(true);
                    } else {
                        ItemStack cursor = event.getCursor();
                        if (cursor.getType().isAir()) {
                            event.setCancelled(true);
                        } else if (event.getHotbarButton() >= 0) {
                            event.setCancelled(true);
                        }
                    }
                }
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!(event.getInventory() instanceof HorseInventory)) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            ItemStack current;
            int slot = (Integer)iterator.next();
            if (slot >= event.getInventory().getSize() || (current = event.getInventory().getItem(slot)) == null || current.getType() == Material.AIR || current.getType() != Material.SADDLE) continue;
            event.setCancelled(true);
            return;
        }
    }
}

