/*
 * Decompiled with CFR 0.152.
 */
package pethorses.listeners;

import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import pethorses.PetHorses;
import pethorses.services.HorseBackpackService;

public class HorseBackpackListener
implements Listener {
    private final PetHorses plugin;
    private final HorseBackpackService backpackService;

    public HorseBackpackListener(PetHorses plugin) {
        this.plugin = plugin;
        this.backpackService = new HorseBackpackService(plugin);
    }

    @EventHandler
    public void onHorseShiftClick(PlayerInteractEntityEvent event) {
        Horse horse;
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Horse) || !(horse = (Horse)entity).isTamed()) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        if (player.isSneaking() && player.getInventory().getItemInMainHand().getType().isAir()) {
            event.setCancelled(true);
            this.backpackService.openBackpack(player, horse);
        }
    }
}

