/*
 * Decompiled with CFR 0.152.
 */
package pethorses.listeners;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import pethorses.PetHorses;
import pethorses.config.LocalizationManager;
import pethorses.services.HorseService;
import pethorses.services.PassengerService;
import pethorses.storage.HorseData;

public class HorseEventListener
implements Listener {
    private final PetHorses plugin;
    private final HorseService horseService;
    private final PassengerService passengerService;
    private final LocalizationManager localizationManager;

    public HorseEventListener(PetHorses plugin) {
        this.plugin = plugin;
        this.horseService = plugin.getHorseService();
        this.passengerService = plugin.getPassengerService();
        this.localizationManager = plugin.getLocalizationManager();
    }

    @EventHandler
    public void onHorseDeath(EntityDeathEvent event) {
        Horse horse;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Horse) || !(horse = (Horse)livingEntity).isTamed()) {
            return;
        }
        AnimalTamer animalTamer = horse.getOwner();
        if (!(animalTamer instanceof Player)) {
            return;
        }
        Player owner = (Player)animalTamer;
        HorseData data = this.horseService.getHorseData(owner.getUniqueId());
        if (data == null) {
            return;
        }
        if (data.getHorseId() == null || !data.getHorseId().equals(horse.getUniqueId())) {
            return;
        }
        event.getDrops().removeIf(item -> item.getType() == Material.SADDLE || item.getType() == Material.LEATHER);
        this.horseService.onHorseDeath(owner.getUniqueId(), horse);
        owner.sendMessage(this.localizationManager.getMessage("horse.death_cooldown").replace("{minutes}", String.valueOf(this.plugin.getConfigManager().getRespawnCooldownMinutes())));
    }

    @EventHandler
    public void onHorseDamage(EntityDamageByEntityEvent event) {
        Horse horse;
        Entity entity = event.getEntity();
        if (!(entity instanceof Horse) || !(horse = (Horse)entity).isTamed()) {
            return;
        }
        Entity entity2 = event.getDamager();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity2;
        Player owner = (Player)horse.getOwner();
        if (owner == null || attacker.getUniqueId().equals(owner.getUniqueId())) {
            return;
        }
        if (!this.plugin.getConfigManager().isOtherPlayersDamageHorsesAllowed()) {
            event.setCancelled(true);
            attacker.sendMessage(this.localizationManager.getMessage("horse.not_yours"));
        }
    }

    @EventHandler
    public void onHorseInteract(PlayerInteractEntityEvent event) {
        Horse horse;
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Horse) || !(horse = (Horse)entity).isTamed()) {
            return;
        }
        Player player = event.getPlayer();
        Player owner = (Player)horse.getOwner();
        if (owner == null) {
            return;
        }
        if (player.getUniqueId().equals(owner.getUniqueId())) {
            return;
        }
        if (!this.passengerService.hasPermission(owner.getUniqueId(), player.getUniqueId())) {
            event.setCancelled(true);
            player.sendMessage(this.localizationManager.getMessage("passenger.no_permission"));
            return;
        }
        if (!horse.getPassengers().isEmpty()) {
            event.setCancelled(true);
            player.sendMessage(this.localizationManager.getMessage("horse.already_has_passenger"));
            return;
        }
        event.setCancelled(true);
        horse.addPassenger((Entity)player);
        player.sendMessage(this.localizationManager.getMessage("horse.passenger_mounted"));
        owner.sendMessage(this.localizationManager.getMessage("horse.passenger_informed_owner").replace("{passenger}", player.getName()));
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        HorseData data;
        Player player = event.getPlayer();
        Entity entity = player.getVehicle();
        if (entity instanceof Horse) {
            Horse horse = (Horse)entity;
            horse.removePassenger((Entity)player);
        }
        if ((data = this.horseService.getHorseData(player.getUniqueId())) != null && data.getHorseId() != null) {
            Entity entity2 = Bukkit.getEntity((UUID)data.getHorseId());
            if (entity2 instanceof Horse) {
                Horse horse = (Horse)entity2;
                for (Entity passenger : horse.getPassengers()) {
                    horse.removePassenger(passenger);
                }
            }
            this.horseService.hideHorse(data);
        }
    }

    @EventHandler
    public void onFallDamage(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Horse)) {
            return;
        }
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        if (!this.plugin.getConfigManager().isFallDamageAllowed()) {
            event.setCancelled(true);
        }
    }
}

