/*
 * Decompiled with CFR 0.152.
 */
package pethorses.listeners;

import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.HorseJumpEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import pethorses.PetHorses;
import pethorses.services.HorseService;

public class HorseMovementListener
implements Listener {
    private final HorseService horseService;

    public HorseMovementListener(PetHorses plugin) {
        this.horseService = plugin.getHorseService();
    }

    @EventHandler
    public void onHorseJump(HorseJumpEvent event) {
        Horse horse;
        AbstractHorse abstractHorse = event.getEntity();
        if (!(abstractHorse instanceof Horse) || !(horse = (Horse)abstractHorse).isTamed()) {
            return;
        }
        Player owner = (Player)horse.getOwner();
        if (owner == null) {
            return;
        }
        this.horseService.addJump(owner.getUniqueId());
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        double dz;
        Horse horse;
        Player player = event.getPlayer();
        Entity entity = player.getVehicle();
        if (!(entity instanceof Horse) || !(horse = (Horse)entity).isTamed()) {
            return;
        }
        Player owner = (Player)horse.getOwner();
        if (owner == null) {
            return;
        }
        double dx = event.getFrom().getX() - event.getTo().getX();
        double horizontalDistance = Math.sqrt(dx * dx + (dz = event.getFrom().getZ() - event.getTo().getZ()) * dz);
        if (horizontalDistance > 0.0) {
            this.horseService.addTraveledBlocks(owner.getUniqueId(), horizontalDistance);
        }
    }
}

