/*
 * Decompiled with CFR 0.152.
 */
package pethorses.menus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import pethorses.PetHorses;
import pethorses.config.LocalizationManager;
import pethorses.inventory.MenuHolder;
import pethorses.services.HorseService;
import pethorses.storage.HorseData;
import pethorses.util.TextUtil;

public class HorseCustomizationMenu
implements Listener {
    private static final int INVENTORY_SIZE = 27;
    private final PetHorses plugin;
    private final HorseService horseService;
    private final LocalizationManager localizationManager;
    private static final Material[] horseColorsMaterials = new Material[]{Material.WHITE_WOOL, Material.BONE_MEAL, Material.ACACIA_PLANKS, Material.SPRUCE_PLANKS, Material.BLACK_WOOL, Material.LIGHT_GRAY_WOOL, Material.DARK_OAK_PLANKS};
    private static final String[] horseColorsKeys = new String[]{"color_white", "color_creamy", "color_chestnut", "color_brown", "color_black", "color_gray", "color_dark_brown"};
    private static final int[] nameColorSlots = new int[]{2, 3, 4, 5, 6, 11, 12, 13, 14, 15, 20, 21, 22, 23, 24};
    private static final Material[] nameColorMaterials = new Material[]{Material.WHITE_DYE, Material.LIGHT_GRAY_DYE, Material.GRAY_DYE, Material.BLACK_DYE, Material.BLUE_DYE, Material.LIGHT_BLUE_DYE, Material.GREEN_DYE, Material.LIME_DYE, Material.CYAN_DYE, Material.RED_DYE, Material.ORANGE_DYE, Material.YELLOW_DYE, Material.BROWN_DYE, Material.PURPLE_DYE, Material.PINK_DYE};
    private static final String[] nameColorKeys = new String[]{"name_color_white", "name_color_gray", "name_color_dark_gray", "name_color_black", "name_color_dark_blue", "name_color_blue", "name_color_dark_green", "name_color_green", "name_color_aqua", "name_color_red", "name_color_gold", "name_color_yellow", "name_color_brown", "name_color_purple", "name_color_light_purple"};
    private static final NamedTextColor[] nameNamedColors = new NamedTextColor[]{NamedTextColor.WHITE, NamedTextColor.GRAY, NamedTextColor.DARK_GRAY, NamedTextColor.BLACK, NamedTextColor.DARK_BLUE, NamedTextColor.BLUE, NamedTextColor.DARK_GREEN, NamedTextColor.GREEN, NamedTextColor.AQUA, NamedTextColor.RED, NamedTextColor.GOLD, NamedTextColor.YELLOW, NamedTextColor.GOLD, NamedTextColor.DARK_PURPLE, NamedTextColor.LIGHT_PURPLE};

    public HorseCustomizationMenu(PetHorses plugin) {
        this.plugin = plugin;
        this.horseService = plugin.getHorseService();
        this.localizationManager = plugin.getLocalizationManager();
    }

    public static void open(Player player, PetHorses plugin) {
        LocalizationManager lm = plugin.getLocalizationManager();
        HorseService hs = plugin.getHorseService();
        MenuHolder holder = new MenuHolder("customize_main");
        Inventory inv = plugin.getServer().createInventory((InventoryHolder)holder, 27, (Component)Component.text((String)lm.getMessage("menu.customize.title")));
        HorseData data = hs.getHorseData(player.getUniqueId());
        HorseCustomizationMenu.setMenuItem(inv, 10, Material.LEATHER, lm.getMessage("menu.customize.color_menu_title"), null);
        HorseCustomizationMenu.setMenuItem(inv, 12, Material.PAPER, lm.getMessage("menu.customize.name_color_menu_title"), null);
        HorseCustomizationMenu.setMenuItem(inv, 14, Material.NAME_TAG, lm.getMessage("menu.customize.name_item"), Arrays.asList(lm.getMessage("menu.customize.current_name").replace("{name}", data.getHorseName() == null ? lm.getMessage("menu.customize.no_name") : data.getHorseName()), lm.getMessage("menu.customize.name_prompt_1"), lm.getMessage("menu.customize.name_prompt_2")));
        HorseCustomizationMenu.setMenuItem(inv, 16, Material.EMERALD, lm.getMessage("menu.customize.save_item"), null);
        player.openInventory(inv);
    }

    public static void openColorMenu(Player player, PetHorses plugin) {
        LocalizationManager lm = plugin.getLocalizationManager();
        MenuHolder holder = new MenuHolder("customize_color");
        Inventory inv = plugin.getServer().createInventory((InventoryHolder)holder, 27, (Component)Component.text((String)lm.getMessage("menu.customize.color_menu_title")));
        for (int i = 0; i < horseColorsMaterials.length; ++i) {
            HorseCustomizationMenu.setMenuItem(inv, 10 + i, horseColorsMaterials[i], lm.getMessage("menu.customize." + horseColorsKeys[i]), null);
        }
        player.openInventory(inv);
    }

    public static void openNameColorMenu(Player player, PetHorses plugin) {
        LocalizationManager lm = plugin.getLocalizationManager();
        MenuHolder holder = new MenuHolder("customize_name_color");
        Inventory inv = plugin.getServer().createInventory((InventoryHolder)holder, 27, (Component)Component.text((String)lm.getMessage("menu.customize.name_color_menu_title")));
        for (int i = 0; i < nameColorMaterials.length; ++i) {
            HorseCustomizationMenu.setMenuItem(inv, nameColorSlots[i], nameColorMaterials[i], lm.getMessage("menu.customize." + nameColorKeys[i]), null);
        }
        player.openInventory(inv);
    }

    private static void setMenuItem(Inventory inv, int slot, Material material, String displayName, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName((Component)Component.text((String)displayName));
            if (lore != null) {
                ArrayList<TextComponent> lc = new ArrayList<TextComponent>();
                for (String s2 : lore) {
                    lc.add(Component.text((String)s2));
                }
                meta.lore(lc);
            }
            item.setItemMeta(meta);
        }
        inv.setItem(slot, item);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof MenuHolder)) {
            return;
        }
        MenuHolder holder = (MenuHolder)inventoryHolder;
        String id = holder.getId();
        if ("customize_main".equals(id)) {
            this.handleMainMenuClick(event);
        } else if ("customize_color".equals(id)) {
            this.handleColorMenuClick(event);
        } else if ("customize_name_color".equals(id)) {
            this.handleNameColorMenuClick(event);
        }
    }

    private void handleMainMenuClick(InventoryClickEvent event) {
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        if (clicked.getType() == Material.LEATHER && event.getSlot() == 10) {
            HorseCustomizationMenu.openColorMenu(player, this.plugin);
            return;
        }
        if (clicked.getType() == Material.PAPER && event.getSlot() == 12) {
            HorseCustomizationMenu.openNameColorMenu(player, this.plugin);
            return;
        }
        final HorseData data = this.horseService.getHorseData(player.getUniqueId());
        if (clicked.getType() == Material.NAME_TAG && event.getSlot() == 14) {
            player.closeInventory();
            player.sendMessage(this.localizationManager.getMessage("menu.customize.enter_name_prompt"));
            this.plugin.getChatInputListener().awaitInput(player, name -> {
                data.setHorseName((String)name);
                player.sendMessage(this.localizationManager.getMessage("menu.customize.name_changed").replace("{name}", (CharSequence)name));
                HorseCustomizationMenu.open(player, this.plugin);
            });
            return;
        }
        if (clicked.getType() == Material.EMERALD && event.getSlot() == 16) {
            Entity horse;
            event.setCancelled(true);
            player.closeInventory();
            player.sendMessage(this.localizationManager.getMessage("menu.customize.saved"));
            data.setOwnerId(player.getUniqueId());
            new BukkitRunnable(){

                public void run() {
                    HorseCustomizationMenu.this.plugin.getHorseDataManager().saveHorseData(data);
                }
            }.runTask((Plugin)this.plugin);
            if (data.getHorseId() != null && (horse = this.plugin.getServer().getEntity(data.getHorseId())) instanceof Horse) {
                Horse h2 = (Horse)horse;
                h2.setColor(data.getColor());
                h2.setStyle(data.getStyle());
                if (data.getHorseName() != null) {
                    h2.customName(TextUtil.colored(data.getHorseNameColor(), data.getHorseName()));
                    h2.setCustomNameVisible(true);
                }
            }
        }
    }

    private void handleColorMenuClick(InventoryClickEvent event) {
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null) {
            return;
        }
        HorseData data = this.horseService.getHorseData(player.getUniqueId());
        boolean updated = false;
        switch (clicked.getType()) {
            case WHITE_WOOL: {
                data.setColor(Horse.Color.WHITE);
                updated = true;
                break;
            }
            case BONE_MEAL: {
                data.setColor(Horse.Color.CREAMY);
                updated = true;
                break;
            }
            case ACACIA_PLANKS: {
                data.setColor(Horse.Color.CHESTNUT);
                updated = true;
                break;
            }
            case SPRUCE_PLANKS: {
                data.setColor(Horse.Color.BROWN);
                updated = true;
                break;
            }
            case BLACK_WOOL: {
                data.setColor(Horse.Color.BLACK);
                updated = true;
                break;
            }
            case LIGHT_GRAY_WOOL: {
                data.setColor(Horse.Color.GRAY);
                updated = true;
                break;
            }
            case DARK_OAK_PLANKS: {
                data.setColor(Horse.Color.DARK_BROWN);
                updated = true;
            }
        }
        if (updated) {
            player.sendMessage(this.localizationManager.getMessage("menu.customize.color_changed"));
            HorseCustomizationMenu.open(player, this.plugin);
        }
    }

    private void handleNameColorMenuClick(InventoryClickEvent event) {
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null) {
            return;
        }
        HorseData data = this.plugin.getHorseService().getHorseData(player.getUniqueId());
        for (int i = 0; i < nameColorMaterials.length; ++i) {
            if (clicked.getType() != nameColorMaterials[i]) continue;
            data.setHorseNameColor(nameNamedColors[i]);
            break;
        }
        HorseCustomizationMenu.open(player, this.plugin);
    }
}

