/*
 * Decompiled with CFR 0.152.
 */
package pethorses.storage;

import java.util.Set;
import java.util.UUID;
import pethorses.PetHorses;
import pethorses.config.ConfigManager;
import pethorses.storage.HorseData;
import pethorses.storage.StorageStrategy;
import pethorses.storage.database.DatabaseStorage;
import pethorses.storage.yaml.YamlStorage;

public class HorseDataManager {
    private final StorageStrategy storage;

    public HorseDataManager(PetHorses plugin) {
        ConfigManager configManager = new ConfigManager(plugin);
        this.storage = configManager.isDatabaseEnabled() ? new DatabaseStorage(plugin, configManager) : new YamlStorage(plugin);
        this.storage.loadData();
    }

    public HorseData getHorseData(UUID playerId) {
        return this.storage.getHorseData(playerId);
    }

    public void saveHorseData(HorseData data) {
        this.storage.saveHorseData(data);
    }

    public void saveAllData() {
        this.storage.saveAllData();
    }

    public Set<UUID> getPassengers(UUID ownerUUID) {
        return this.storage.getPassengers(ownerUUID);
    }

    public void addPassenger(UUID ownerUUID, UUID passengerUUID) {
        this.storage.addPassenger(ownerUUID, passengerUUID);
    }

    public void removePassenger(UUID ownerUUID, UUID passengerUUID) {
        this.storage.removePassenger(ownerUUID, passengerUUID);
    }

    public void close() {
        if (this.storage instanceof DatabaseStorage) {
            ((DatabaseStorage)this.storage).close();
        }
    }

    public Set<UUID> getAllPlayerIds() {
        if (this.storage instanceof YamlStorage) {
            return ((YamlStorage)this.storage).getAllPlayerIds();
        }
        if (this.storage instanceof DatabaseStorage) {
            return ((DatabaseStorage)this.storage).getAllPlayerIds();
        }
        return Set.of();
    }
}

