/*
 * Decompiled with CFR 0.152.
 */
package pethorses.storage.database;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import pethorses.config.ConfigManager;

public class DatabaseManager {
    private final HikariDataSource dataSource;

    public DatabaseManager(ConfigManager config) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl("jdbc:mariadb://" + config.getDatabaseHost() + ":" + config.getDatabasePort() + "/" + config.getDatabaseName());
        hikariConfig.setUsername(config.getDatabaseUser());
        hikariConfig.setPassword(config.getDatabasePassword());
        hikariConfig.setMaximumPoolSize(10);
        hikariConfig.setConnectionTimeout(10000L);
        hikariConfig.setPoolName("PetHorsesPool");
        hikariConfig.setDriverClassName("org.mariadb.jdbc.Driver");
        this.dataSource = new HikariDataSource(hikariConfig);
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void close() {
        this.dataSource.close();
    }
}

