/*
 * Decompiled with CFR 0.152.
 */
package pethorses.storage.database;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class ItemStackSerializer {
    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] serialize(ItemStack[] items, Logger logger) {
        if (items == null || items.length == 0) {
            return null;
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);){
                dataOutput.writeInt(items.length);
                for (ItemStack item : items) {
                    dataOutput.writeObject((Object)item);
                }
                byArray = outputStream.toByteArray();
            }
            return byArray;
        }
        catch (Exception e) {
            logger.warning("Error serializing item stacks: " + e.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ItemStack[] deserialize(byte[] data, Logger logger) {
        if (data == null || data.length == 0) {
            return new ItemStack[0];
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data);){
            ItemStack[] itemStackArray;
            try (BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);){
                int size = dataInput.readInt();
                ItemStack[] items = new ItemStack[size];
                for (int i = 0; i < size; ++i) {
                    items[i] = (ItemStack)dataInput.readObject();
                }
                itemStackArray = items;
            }
            return itemStackArray;
        }
        catch (Exception e) {
            logger.warning("Error deserializing item stacks: " + e.getMessage());
            return new ItemStack[0];
        }
    }
}

