/*
 * Decompiled with CFR 0.152.
 */
package pethorses.storage.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import pethorses.storage.database.DatabaseManager;

public class PassengerRepository {
    private final DatabaseManager dbManager;
    private final Logger logger;

    public PassengerRepository(DatabaseManager dbManager, Logger logger) {
        this.dbManager = dbManager;
        this.logger = logger;
        this.initializeTable();
    }

    private void initializeTable() {
        try (Connection conn = this.dbManager.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS pet_horse_passengers (owner_uuid VARCHAR(36),passenger_uuid VARCHAR(36),PRIMARY KEY (owner_uuid, passenger_uuid))");
        }
        catch (SQLException e) {
            this.logger.severe("Error initializing passenger table: " + e.getMessage());
        }
    }

    public Map<UUID, Set<UUID>> loadAll() {
        HashMap<UUID, Set<UUID>> permissions = new HashMap<UUID, Set<UUID>>();
        try (Connection conn = this.dbManager.getConnection();
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT * FROM pet_horse_passengers");){
            while (rs.next()) {
                UUID ownerId = UUID.fromString(rs.getString("owner_uuid"));
                UUID passengerId = UUID.fromString(rs.getString("passenger_uuid"));
                permissions.computeIfAbsent(ownerId, k -> new HashSet()).add(passengerId);
            }
        }
        catch (SQLException e) {
            this.logger.severe("Error loading passengers: " + e.getMessage());
        }
        return permissions;
    }

    public void addPassenger(UUID ownerId, UUID passengerId) {
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement("INSERT INTO pet_horse_passengers (owner_uuid, passenger_uuid) VALUES (?, ?)");){
            stmt.setString(1, ownerId.toString());
            stmt.setString(2, passengerId.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.logger.warning("Error adding passenger: " + e.getMessage());
        }
    }

    public void removePassenger(UUID ownerId, UUID passengerId) {
        try (Connection conn = this.dbManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement("DELETE FROM pet_horse_passengers WHERE owner_uuid = ? AND passenger_uuid = ?");){
            stmt.setString(1, ownerId.toString());
            stmt.setString(2, passengerId.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.logger.warning("Error removing passenger: " + e.getMessage());
        }
    }
}

