/*
 * Decompiled with CFR 0.152.
 */
package pethorses.storage.yaml;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.ItemStack;
import pethorses.storage.HorseData;
import pethorses.util.TextUtil;

public class YamlHorseDataRepository {
    private final FileConfiguration config;

    public YamlHorseDataRepository(FileConfiguration config) {
        this.config = config;
    }

    public HorseData load(UUID playerId) {
        List backpackList;
        String key = playerId.toString();
        HorseData data = new HorseData();
        data.setOwnerId(playerId);
        data.setLevel(this.config.getInt(key + ".level", 1));
        data.setExperience(this.config.getInt(key + ".experience", 0));
        data.setColor(this.parseColor(this.config.getString(key + ".color", "BROWN")));
        data.setStyle(this.parseStyle(this.config.getString(key + ".style", "NONE")));
        data.setHorseName(this.config.getString(key + ".name"));
        data.setHorseNameColor(this.parseNamedTextColor(this.config.getString(key + ".horseNameColor", null)));
        data.setDeathTime(this.config.getLong(key + ".deathTime", 0L));
        data.setJumps(this.config.getInt(key + ".jumps", 0));
        data.setBlocksTraveled(this.config.getDouble(key + ".blocksTraveled", 0.0));
        data.setTotalJumps(this.config.getInt(key + ".totalJumps", 0));
        data.setTotalBlocksTraveled(this.config.getDouble(key + ".totalBlocksTraveled", 0.0));
        if (this.config.contains(key + ".backpack") && (backpackList = this.config.getList(key + ".backpack")) != null) {
            ItemStack[] backpackItems = new ItemStack[backpackList.size()];
            for (int i = 0; i < backpackList.size(); ++i) {
                Object o = backpackList.get(i);
                backpackItems[i] = o instanceof ItemStack ? (ItemStack)o : null;
            }
            data.setBackpackItems(backpackItems);
        }
        if (this.config.contains(key + ".armor")) {
            data.setArmorItem(this.config.getItemStack(key + ".armor"));
        }
        return data;
    }

    public void save(HorseData data) {
        if (data == null || data.getOwnerId() == null) {
            return;
        }
        String key = data.getOwnerId().toString();
        this.config.set(key + ".level", (Object)data.getLevel());
        this.config.set(key + ".experience", (Object)data.getExperience());
        this.config.set(key + ".color", (Object)(data.getColor() != null ? data.getColor().name() : Horse.Color.BROWN.name()));
        this.config.set(key + ".style", (Object)(data.getStyle() != null ? data.getStyle().name() : Horse.Style.NONE.name()));
        this.config.set(key + ".name", (Object)data.getHorseName());
        NamedTextColor ntc = data.getHorseNameColor();
        String saveColor = TextUtil.namedTextColorToKey(ntc);
        this.config.set(key + ".horseNameColor", (Object)saveColor);
        this.config.set(key + ".deathTime", (Object)data.getDeathTime());
        this.config.set(key + ".jumps", (Object)data.getJumps());
        this.config.set(key + ".blocksTraveled", (Object)data.getBlocksTraveled());
        this.config.set(key + ".totalJumps", (Object)data.getTotalJumps());
        this.config.set(key + ".totalBlocksTraveled", (Object)data.getTotalBlocksTraveled());
        if (data.getBackpackItems() != null && data.getBackpackItems().length > 0) {
            this.config.set(key + ".backpack", Arrays.asList(data.getBackpackItems()));
        } else {
            this.config.set(key + ".backpack", null);
        }
        this.config.set(key + ".armor", (Object)data.getArmorItem());
    }

    private Horse.Color parseColor(String colorStr) {
        try {
            return Horse.Color.valueOf((String)colorStr);
        }
        catch (Exception e) {
            return Horse.Color.BROWN;
        }
    }

    private Horse.Style parseStyle(String styleStr) {
        try {
            return Horse.Style.valueOf((String)styleStr);
        }
        catch (Exception e) {
            return Horse.Style.NONE;
        }
    }

    private NamedTextColor parseNamedTextColor(String colorStr) {
        if (colorStr == null) {
            return NamedTextColor.WHITE;
        }
        return TextUtil.parseNamedTextColor(colorStr);
    }
}

