/*
 * Decompiled with CFR 0.152.
 */
package pethorses.storage.yaml;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.FileConfiguration;

public class YamlPassengerRepository {
    private final FileConfiguration config;

    public YamlPassengerRepository(FileConfiguration config) {
        this.config = config;
    }

    public Set<UUID> load(UUID ownerId) {
        String key = ownerId.toString();
        HashSet<UUID> passengers = new HashSet<UUID>();
        if (this.config.contains(key + ".passengers")) {
            for (String passengerId : this.config.getStringList(key + ".passengers")) {
                try {
                    passengers.add(UUID.fromString(passengerId));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return passengers;
    }

    public void save(UUID ownerId, Set<UUID> passengers) {
        String key = ownerId.toString();
        List list = passengers.stream().map(UUID::toString).collect(Collectors.toList());
        this.config.set(key + ".passengers", list);
    }
}

