/*
 * Decompiled with CFR 0.152.
 */
package me.cutebow.crystalanchorcounter.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.Objects;
import me.cutebow.crystalanchorcounter.client.config.CounterConfig;
import me.cutebow.crystalanchorcounter.client.util.Mode;
import me.cutebow.crystalanchorcounter.client.util.Position;
import me.cutebow.crystalanchorcounter.client.util.Theme;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class ConfigManager {
    public static CounterConfig config = new CounterConfig();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/crystal_anchor_counter.json");

    public static void setTheme(Theme theme) {
        ConfigManager.config.theme = theme;
        ConfigManager.save();
    }

    public static void setPosition(Position position) {
        ConfigManager.config.position = position;
        ConfigManager.save();
    }

    public static void setFormat(String format) {
        ConfigManager.config.format = format;
        ConfigManager.save();
    }

    public static void setMode(Mode mode) {
        ConfigManager.config.mode = mode;
        ConfigManager.save();
    }

    public static void setHudEnabled(boolean enabled) {
        ConfigManager.config.hudEnabled = enabled;
        ConfigManager.save();
    }

    public static int getDynamicYOffset() {
        if (ConfigManager.config.position == Position.HOTBAR) {
            class_310 mc = class_310.method_1551();
            Objects.requireNonNull(mc.field_1690);
            int n = 9;
            boolean hasInv = mc.field_1724 != null && !mc.field_1724.method_31548().method_5442();
            return -(hasInv ? n * 3 : n * 2);
        }
        return ConfigManager.config.yOffset;
    }

    public static void load() {
        block14: {
            try {
                if (CONFIG_FILE.exists()) {
                    try (FileReader r = new FileReader(CONFIG_FILE);){
                        config = (CounterConfig)GSON.fromJson((Reader)r, CounterConfig.class);
                        break block14;
                    }
                }
                ConfigManager.save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        boolean changed = false;
        if (ConfigManager.config.theme == null) {
            ConfigManager.config.theme = Theme.WHITE;
            changed = true;
        }
        if (ConfigManager.config.position == null) {
            ConfigManager.config.position = Position.HOTBAR;
            changed = true;
        }
        if (ConfigManager.config.mode == null) {
            ConfigManager.config.mode = Mode.LIVE;
            changed = true;
        }
        if (ConfigManager.config.format == null) {
            ConfigManager.config.format = "short";
            changed = true;
        }
        if (ConfigManager.config.hudEnabled == null) {
            ConfigManager.config.hudEnabled = true;
            changed = true;
        }
        if (changed) {
            ConfigManager.save();
        }
    }

    public static void save() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            try (FileWriter w = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)config, (Appendable)w);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

