/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.lifetime.trackeddata;

import carpettisaddition.commands.lifetime.removal.RemovalReason;
import carpettisaddition.commands.lifetime.spawning.SpawningReason;
import carpettisaddition.commands.lifetime.trackeddata.BasicTrackedData;
import carpettisaddition.commands.lifetime.utils.LifeTimeTrackerContext;
import carpettisaddition.utils.CommandUtils;
import carpettisaddition.utils.CounterUtils;
import carpettisaddition.utils.Messenger;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_2554;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public abstract class ExtraCountTrackedData
extends BasicTrackedData {
    public final Map<SpawningReason, Long> spawningExtraCountMap = Maps.newHashMap();
    public final Map<RemovalReason, Long> removalExtraCountMap = Maps.newHashMap();

    protected abstract long getExtraCount(class_1297 var1);

    @Override
    public void updateSpawning(class_1297 entity, SpawningReason reason) {
        super.updateSpawning(entity, reason);
        this.spawningExtraCountMap.put(reason, this.spawningExtraCountMap.getOrDefault(reason, 0L) + this.getExtraCount(entity));
    }

    @Override
    public void updateRemoval(class_1297 entity, RemovalReason reason) {
        super.updateRemoval(entity, reason);
        this.removalExtraCountMap.put(reason, this.removalExtraCountMap.getOrDefault(reason, 0L) + this.getExtraCount(entity));
    }

    protected abstract class_2554 getCountDisplayText();

    protected abstract String getCountButtonString();

    private class_2554 attachExtraCount(class_2554 text, long extraCount, @Nullable Long extraTotal, long ticks) {
        class_2554 extra = Messenger.c(this.getCountDisplayText(), "g : ", CounterUtils.ratePerHourText(extraCount, ticks, "wgg"));
        if (extraTotal != null) {
            double percentage = 100.0 * (double)extraCount / (double)extraTotal.longValue();
            extra.method_10852((class_2561)Messenger.c("w  ", Messenger.hover(Messenger.s(String.format("%.1f%%", percentage)), Messenger.s(String.format("%.6f%%", percentage)))));
        }
        text = CommandUtils.isConsoleCommandSource(LifeTimeTrackerContext.commandSource.get()) ? Messenger.c(text, "y  [", extra, "y ]") : Messenger.c(text, Messenger.s(" "), Messenger.hover(Messenger.s((Object)("[" + this.getCountButtonString() + "]"), "y"), extra));
        return text;
    }

    @Override
    public class_2554 getSpawningCountText(long ticks) {
        return this.attachExtraCount(super.getSpawningCountText(ticks), ExtraCountTrackedData.getLongMapSum(this.spawningExtraCountMap), null, ticks);
    }

    @Override
    public class_2554 getRemovalCountText(long ticks) {
        return this.attachExtraCount(super.getRemovalCountText(ticks), ExtraCountTrackedData.getLongMapSum(this.removalExtraCountMap), null, ticks);
    }

    @Override
    protected class_2554 getSpawningReasonWithRate(SpawningReason reason, long ticks, long count, long total, String indent) {
        return this.attachExtraCount(super.getSpawningReasonWithRate(reason, ticks, count, total, indent), this.spawningExtraCountMap.getOrDefault(reason, 0L), ExtraCountTrackedData.getLongMapSum(this.spawningExtraCountMap), ticks);
    }

    @Override
    protected class_2554 getRemovalReasonWithRate(RemovalReason reason, long ticks, long count, long total, String indent) {
        return this.attachExtraCount(super.getRemovalReasonWithRate(reason, ticks, count, total, indent), this.removalExtraCountMap.getOrDefault(reason, 0L), ExtraCountTrackedData.getLongMapSum(this.removalExtraCountMap), ticks);
    }
}

