/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.manipulate.container.controller;

import carpettisaddition.commands.CommandTreeContext;
import carpettisaddition.commands.manipulate.container.controller.AbstractEntityListController;
import carpettisaddition.mixins.command.manipulate.container.WorldAccessor;
import carpettisaddition.utils.GameUtils;
import carpettisaddition.utils.IdentifierUtils;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.compat.DimensionWrapper;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2554;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_3218;
import net.minecraft.class_5562;

public class TileEntityListController
extends AbstractEntityListController {
    private static final int TOP_N = 10;

    public TileEntityListController() {
        super("tile_entity");
    }

    @Override
    protected boolean canManipulate(class_3218 world) {
        return !((WorldAccessor)world).isIteratingTickingBlockEntities();
    }

    @Override
    protected int processWholeList(class_3218 world, Consumer<List<?>> collectionOperator) {
        List<class_5562> blockEntityTickers = ((WorldAccessor)world).getBlockEntityTickers();
        collectionOperator.accept(blockEntityTickers);
        return blockEntityTickers.size();
    }

    private static List<class_2586> extractFromTicker(Collection<class_5562> tickers) {
        return tickers.stream().map(GameUtils::getBlockEntityFromTickInvoker).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static List<class_2586> getTickingBlockEntities(class_3218 world) {
        return TileEntityListController.extractFromTicker(((WorldAccessor)world).getBlockEntityTickers());
    }

    private int queryTileEntityInfo(class_2168 source, class_2338 pos) {
        class_3218 world = source.method_9225();
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity != null) {
            List<class_2586> blockEntityList = TileEntityListController.getTickingBlockEntities(world);
            int index = blockEntityList.indexOf(blockEntity);
            Messenger.tell(source, Arrays.asList(this.tr("query.title", Messenger.coord((class_2382)pos, DimensionWrapper.of((class_1937)world))), Messenger.format("- %1$s: %2$s", this.tr("query.type", new Object[0]), Messenger.blockEntity(blockEntity)), Messenger.format("- %1$s: %2$s", this.tr("query.ticking_order", new Object[0]), index != -1 ? Integer.valueOf(index) : "N/A")));
            return 1;
        }
        Messenger.tell(source, this.tr("query.not_found", Messenger.coord((class_2382)pos, DimensionWrapper.of((class_1937)world))));
        return 0;
    }

    private void showTopNInCollection(class_2168 source, class_2554 name, Collection<class_2586> blockEntities) {
        HashMultiset counter = HashMultiset.create();
        blockEntities.stream().map(class_2586::method_11017).forEach(arg_0 -> ((Multiset)counter).add(arg_0));
        List topN = counter.entrySet().stream().sorted(Collections.reverseOrder(Comparator.comparingInt(Multiset.Entry::getCount))).limit(10L).collect(Collectors.toList());
        Messenger.tell(source, Messenger.format("%1$s: %2$sx", name, blockEntities.size()));
        for (int i = 0; i < topN.size(); ++i) {
            Multiset.Entry entry = (Multiset.Entry)topN.get(i);
            Messenger.tell(source, Messenger.formatting(Messenger.format("%1$s. %2$s: %3$sx", i + 1, IdentifierUtils.id((class_2591)entry.getElement()), entry.getCount()), "g"));
        }
    }

    private int showStatistic(class_2168 source) {
        class_3218 world = source.method_9225();
        Messenger.tell(source, Messenger.format("===== %1$s =====", this.tr("statistic.title", Messenger.dimension(DimensionWrapper.of((class_1937)world)))));
        this.showTopNInCollection(source, this.tr("statistic.ticking", new Object[0]), TileEntityListController.getTickingBlockEntities(world));
        return 1;
    }

    @Override
    public ArgumentBuilder<class_2168, ?> getCommandNode(CommandTreeContext context) {
        return super.getCommandNode(context).then(class_2170.method_9247((String)"statistic").executes(c -> this.showStatistic((class_2168)c.getSource()))).then(class_2170.method_9247((String)"query").then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(c -> this.queryTileEntityInfo((class_2168)c.getSource(), class_2262.method_9696((CommandContext)c, (String)"pos")))));
    }
}

