/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.logger.microtiming.events.blockupdate;

import carpettisaddition.logging.loggers.microtiming.MicroTimingLoggerManager;
import carpettisaddition.logging.loggers.microtiming.enums.BlockUpdateType;
import carpettisaddition.logging.loggers.microtiming.enums.EventType;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingUtil;
import com.llamalad7.mixinextras.sugar.Local;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public abstract class WorldMixins {

    @Restriction(require={@Condition(value="minecraft", versionPredicates={">=1.19"})})
    @Mixin(value={class_1937.class})
    public static class SingleStateUpdateMixin {
    }

    @Restriction(require={@Condition(value="minecraft", versionPredicates={">=1.19"})})
    @Mixin(value={class_3218.class})
    public static class SingleBlockUpdate2Mixin {
    }

    @Mixin(value={class_1937.class})
    public static class SingleBlockUpdateMixin {
        @Inject(method={"updateNeighbor(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/Block;Lnet/minecraft/util/math/BlockPos;)V"}, at={@At(value="HEAD")})
        private void startUpdateSingleBlock(CallbackInfo ci, @Local(argsOnly=true, ordinal=0) class_2338 sourcePos, @Local(argsOnly=true) class_2248 sourceBlock) {
            if (MicroTimingUtil.isBlockUpdateInstant((class_1937)this)) {
                MicroTimingLoggerManager.onBlockUpdate((class_1937)this, sourcePos, sourceBlock, BlockUpdateType.SINGLE_BLOCK_UPDATE, null, EventType.ACTION_START);
            } else {
                MicroTimingLoggerManager.onScheduleBlockUpdate((class_1937)this, sourcePos, sourceBlock, BlockUpdateType.SINGLE_BLOCK_UPDATE, null);
            }
        }

        @Inject(method={"updateNeighbor(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/Block;Lnet/minecraft/util/math/BlockPos;)V"}, at={@At(value="TAIL")})
        private void endUpdateSingleBlock(CallbackInfo ci, @Local(argsOnly=true, ordinal=0) class_2338 sourcePos, @Local(argsOnly=true) class_2248 sourceBlock) {
            if (MicroTimingUtil.isBlockUpdateInstant((class_1937)this)) {
                MicroTimingLoggerManager.onBlockUpdate((class_1937)this, sourcePos, sourceBlock, BlockUpdateType.SINGLE_BLOCK_UPDATE, null, EventType.ACTION_END);
            }
        }
    }

    @Mixin(value={class_1937.class})
    public static class ComparatorUpdateMixin {
        @Inject(method={"updateComparators"}, at={@At(value="HEAD")})
        private void startUpdateComparator(class_2338 pos, class_2248 block, CallbackInfo ci) {
            if (MicroTimingUtil.isBlockUpdateInstant((class_1937)this)) {
                MicroTimingLoggerManager.onBlockUpdate((class_1937)this, pos, block, BlockUpdateType.COMPARATOR_UPDATE, null, EventType.ACTION_START);
            } else {
                MicroTimingLoggerManager.onScheduleBlockUpdate((class_1937)this, pos, block, BlockUpdateType.COMPARATOR_UPDATE, null);
            }
        }

        @Inject(method={"updateComparators"}, at={@At(value="RETURN")})
        private void endUpdateComparator(class_2338 pos, class_2248 block, CallbackInfo ci) {
            if (MicroTimingUtil.isBlockUpdateInstant((class_1937)this)) {
                MicroTimingLoggerManager.onBlockUpdate((class_1937)this, pos, block, BlockUpdateType.COMPARATOR_UPDATE, null, EventType.ACTION_END);
            }
        }
    }

    @Mixin(value={class_1937.class})
    public static class BlockUpdateExceptMixin {
        @Inject(method={"updateNeighborsExcept"}, at={@At(value="HEAD")})
        private void startUpdateNeighborsExcept(CallbackInfo ci, @Local(argsOnly=true) class_2338 pos, @Local(argsOnly=true) class_2248 sourceBlock, @Local(argsOnly=true) class_2350 direction) {
            if (MicroTimingUtil.isBlockUpdateInstant((class_1937)this)) {
                MicroTimingLoggerManager.onBlockUpdate((class_1937)this, pos, sourceBlock, BlockUpdateType.BLOCK_UPDATE_EXCEPT, direction, EventType.ACTION_START);
            } else {
                MicroTimingLoggerManager.onScheduleBlockUpdate((class_1937)this, pos, sourceBlock, BlockUpdateType.BLOCK_UPDATE_EXCEPT, direction);
            }
        }

        @Inject(method={"updateNeighborsExcept"}, at={@At(value="RETURN")})
        private void endUpdateNeighborsExcept(CallbackInfo ci, @Local(argsOnly=true) class_2338 pos, @Local(argsOnly=true) class_2248 sourceBlock, @Local(argsOnly=true) class_2350 direction) {
            if (MicroTimingUtil.isBlockUpdateInstant((class_1937)this)) {
                MicroTimingLoggerManager.onBlockUpdate((class_1937)this, pos, sourceBlock, BlockUpdateType.BLOCK_UPDATE_EXCEPT, direction, EventType.ACTION_END);
            }
        }
    }

    @Mixin(value={class_1937.class})
    public static class BlockUpdateMixin {
        @Inject(method={"updateNeighborsAlways"}, at={@At(value="HEAD")})
        private void startUpdateNeighborsAlways(CallbackInfo ci, @Local(argsOnly=true) class_2338 pos, @Local(argsOnly=true) class_2248 block) {
            if (MicroTimingUtil.isBlockUpdateInstant((class_1937)this)) {
                MicroTimingLoggerManager.onBlockUpdate((class_1937)this, pos, block, BlockUpdateType.BLOCK_UPDATE, null, EventType.ACTION_START);
            } else {
                MicroTimingLoggerManager.onScheduleBlockUpdate((class_1937)this, pos, block, BlockUpdateType.BLOCK_UPDATE, null);
            }
        }

        @Inject(method={"updateNeighborsAlways"}, at={@At(value="RETURN")})
        private void endUpdateNeighborsAlways(CallbackInfo ci, @Local(argsOnly=true) class_2338 pos, @Local(argsOnly=true) class_2248 block) {
            if (MicroTimingUtil.isBlockUpdateInstant((class_1937)this)) {
                MicroTimingLoggerManager.onBlockUpdate((class_1937)this, pos, block, BlockUpdateType.BLOCK_UPDATE, null, EventType.ACTION_END);
            }
        }
    }
}

