/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.utils;

import carpettisaddition.mixins.utils.ServerCommandSourceAccessor;
import carpettisaddition.utils.PlayerUtils;
import carpettisaddition.utils.command.BuilderFactory;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.class_12087;
import net.minecraft.class_12090;
import net.minecraft.class_12094;
import net.minecraft.class_1657;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class CommandUtils {
    public static boolean isConsoleCommandSource(class_2168 commandSource) {
        if (commandSource != null) {
            class_2165 output = ((ServerCommandSourceAccessor)commandSource).getOutput();
            return output instanceof MinecraftServer;
        }
        return false;
    }

    public static Optional<class_3222> getPlayer(class_2168 source) {
        if (source != null) {
            try {
                return Optional.ofNullable(source.method_9207());
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static boolean isPlayerCommandSource(class_2168 source) {
        return CommandUtils.getPlayer(source).isPresent();
    }

    public static boolean isCreativePlayer(class_2168 source) {
        return CommandUtils.getPlayer(source).map(class_1657::method_56992).orElse(false);
    }

    public static boolean isOperatorPlayer(class_2168 source) {
        return CommandUtils.getPlayer(source).map(player -> PlayerUtils.isOperator(source.method_9211(), (class_1657)player)).orElse(false);
    }

    public static boolean isSinglePlayerOwner(class_2168 source) {
        MinecraftServer server = source.method_9211();
        return CommandUtils.getPlayer(source).map(player -> server.method_19466(player.method_72498())).orElse(false);
    }

    public static boolean canCheat(class_2168 source) {
        return CommandUtils.hasPermissionLevel(source, 2);
    }

    public static boolean hasPermissionLevel(class_2168 source, int level) {
        class_12087.class_12089 permission = new class_12087.class_12089(class_12094.method_75027((int)level));
        return new class_12090.class_12092((class_12087)permission).method_75022(source.method_75037());
    }

    public static <T> Optional<T> getOptArg(ArgumentGetter<T> argGetter) throws CommandSyntaxException {
        try {
            return Optional.of(argGetter.get());
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public static RequiredArgumentBuilder<class_2168, String> enumArg(String name, Class<? extends Enum<?>> enumClass) {
        return class_2170.method_9244((String)name, (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9264(Arrays.stream((Enum[])enumClass.getEnumConstants()).map(e -> e.name().toLowerCase()), (SuggestionsBuilder)b));
    }

    public static BuilderFactory<RequiredArgumentBuilder<class_2168, String>> enumArg(Class<? extends Enum<?>> enumClass) {
        return name -> CommandUtils.enumArg(name, enumClass);
    }

    public static <T extends Enum<T>> Optional<T> getEnum(CommandContext<?> context, String argName, Class<T> enumClass) {
        String enumString = StringArgumentType.getString(context, (String)argName);
        try {
            return Optional.of(Enum.valueOf(enumClass, enumString.toUpperCase()));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    @FunctionalInterface
    public static interface ArgumentGetter<T> {
        public T get() throws CommandSyntaxException;
    }
}

