/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.info;

import carpettisaddition.commands.AbstractCommand;
import carpettisaddition.commands.CommandExtender;
import carpettisaddition.commands.CommandTreeContext;
import carpettisaddition.commands.info.InfoSubcommand;
import carpettisaddition.commands.info.QueueAccessibleChunkTickScheduler;
import carpettisaddition.commands.info.world.InfoWorldCommand;
import carpettisaddition.mixins.command.info.ServerWorldAccessor;
import carpettisaddition.mixins.command.info.WorldTickSchedulerAccessor;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.WorldUtils;
import com.google.common.collect.Lists;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1919;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1953;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2554;
import net.minecraft.class_3218;
import net.minecraft.class_6755;
import net.minecraft.class_6757;
import net.minecraft.class_6760;

public class InfoCommandExtension
extends AbstractCommand
implements CommandExtender {
    private static final InfoCommandExtension INSTANCE = new InfoCommandExtension();

    public static InfoCommandExtension getInstance() {
        return INSTANCE;
    }

    public InfoCommandExtension() {
        super("info");
    }

    @Override
    public void extendCommand(CommandTreeContext.Node context) {
        BiConsumer<String, InfoSubcommand> extend = (name, subcommand) -> {
            LiteralArgumentBuilder worldNode = class_2170.method_9247((String)name);
            subcommand.extendCommand(context.node((ArgumentBuilder<class_2168, ?>)worldNode));
            context.node.then((ArgumentBuilder)worldNode);
        };
        extend.accept("world", InfoWorldCommand.getInstance());
    }

    private <T> void appendTileTickInfo(List<class_2554> result, List<class_6760<T>> tileTickList, String title, long currentTime, Function<T, class_2554> nameGetter) {
        if (!tileTickList.isEmpty()) {
            result.add(Messenger.s(String.format(" - %s * %d", title, tileTickList.size())));
            for (class_6760<T> tt : tileTickList) {
                long time = tt.comp_254();
                class_1953 priority = tt.comp_255();
                result.add(Messenger.c("w     ", nameGetter.apply(tt.comp_252()), String.format("w : time = %d (+%dgt), priority = %d", time, time - currentTime, priority.method_8681())));
            }
        }
    }

    private void appendBlockEventInfo(List<class_2554> result, List<class_1919> blockEvents) {
        if (!blockEvents.isEmpty()) {
            result.add(Messenger.s(" - Queued Block Events * " + blockEvents.size()));
            for (class_1919 be : blockEvents) {
                result.add(Messenger.c("w     ", Messenger.block(be.comp_61()), String.format("w : id = %d, param = %d", be.comp_62(), be.comp_63())));
            }
        }
    }

    private <T> List<class_6760<T>> getTileTicksAt(class_6757<T> wts, class_2338 pos) {
        Queue queue;
        class_6755 cts = (class_6755)((WorldTickSchedulerAccessor)wts).getChunkTickSchedulers().get(class_1923.method_37232((class_2338)pos));
        if (cts != null && (queue = ((QueueAccessibleChunkTickScheduler)cts).getTickQueue$TISCM()) != null) {
            return queue.stream().filter(t -> t.comp_253().equals((Object)pos)).sorted(class_6760.field_35549).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public Collection<class_2554> showMoreBlockInfo(class_2338 pos, class_1937 world) {
        if (!(world instanceof class_3218)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        List blockTileTicks = this.getTileTicksAt((class_6757)world.method_8397(), pos);
        List liquidTileTicks = this.getTileTicksAt((class_6757)world.method_8405(), pos);
        this.appendTileTickInfo(result, blockTileTicks, "Block Tile ticks", WorldUtils.getWorldTime(world), Messenger::block);
        this.appendTileTickInfo(result, liquidTileTicks, "Fluid Tile ticks", WorldUtils.getWorldTime(world), Messenger::fluid);
        List<class_1919> blockEvents = ((ServerWorldAccessor)world).getPendingBlockActions().stream().filter(be -> be.comp_60().equals((Object)pos)).collect(Collectors.toList());
        this.appendBlockEventInfo(result, blockEvents);
        return result;
    }
}

