/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.lifetime;

import carpettisaddition.CarpetTISAdditionMod;
import carpettisaddition.commands.AbstractTracker;
import carpettisaddition.commands.lifetime.LifeTimeWorldTracker;
import carpettisaddition.commands.lifetime.interfaces.LifetimeTrackerTarget;
import carpettisaddition.commands.lifetime.interfaces.ServerWorldWithLifeTimeTracker;
import carpettisaddition.commands.lifetime.recorder.LifetimeRecorder;
import carpettisaddition.commands.lifetime.utils.LifeTimeTrackerContext;
import carpettisaddition.commands.lifetime.utils.LifeTimeTrackerUtil;
import carpettisaddition.commands.lifetime.utils.SpecificDetailMode;
import carpettisaddition.utils.Messenger;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2554;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LifeTimeTracker
extends AbstractTracker {
    private static boolean attachedServer = false;
    private static final LifeTimeTracker INSTANCE = new LifeTimeTracker();
    private int currentTrackId = 0;
    private final Map<class_3218, LifeTimeWorldTracker> trackers = new Reference2ObjectArrayMap();

    public LifeTimeTracker() {
        super("LifeTime");
    }

    public static LifeTimeTracker getInstance() {
        return INSTANCE;
    }

    public LifeTimeWorldTracker getTracker(class_1937 world) {
        return world instanceof class_3218 ? this.trackers.get(world) : null;
    }

    public static void attachServer(MinecraftServer minecraftServer) {
        attachedServer = true;
        LifeTimeTracker.INSTANCE.trackers.clear();
        for (class_3218 world : minecraftServer.method_3738()) {
            LifeTimeTracker.INSTANCE.trackers.put(world, ((ServerWorldWithLifeTimeTracker)world).getLifeTimeWorldTracker());
        }
        LifetimeRecorder.getInstance();
    }

    public static void detachServer() {
        attachedServer = false;
        INSTANCE.stop();
    }

    public static boolean isActivated() {
        return attachedServer && INSTANCE.isTracking();
    }

    public boolean willTrackEntity(class_1297 entity, boolean checkTrackId) {
        return LifeTimeTracker.isActivated() && (!checkTrackId || ((LifetimeTrackerTarget)entity).getTrackId() == this.getCurrentTrackId()) && LifeTimeTrackerUtil.isTrackedEntityClass(entity);
    }

    public Stream<String> getAvailableEntityType() {
        if (!LifeTimeTracker.isActivated()) {
            return Stream.empty();
        }
        return this.trackers.values().stream().flatMap(tracker -> tracker.getDataMap().keySet().stream().map(LifeTimeTrackerUtil::getEntityTypeDescriptor)).distinct();
    }

    public int getCurrentTrackId() {
        return this.currentTrackId;
    }

    @Override
    public int startTracking(@NotNull class_2168 source, boolean isRestart, boolean showFeedback) {
        int ret = super.startTracking(source, isRestart, showFeedback);
        if (!isRestart && ret == 1) {
            LifetimeRecorder.getInstance().start(source, this.currentTrackId);
        }
        return ret;
    }

    @Override
    public int stopTracking(@Nullable class_2168 source, boolean isRestart, boolean showFeedback) {
        int ret = super.stopTracking(source, isRestart, showFeedback);
        if (!isRestart && ret == 1) {
            LifetimeRecorder.getInstance().stop(source);
        }
        return ret;
    }

    @Override
    public int restartTracking(class_2168 source) {
        int ret = super.restartTracking(source);
        LifetimeRecorder.getInstance().start(source, this.currentTrackId);
        return ret;
    }

    @Override
    protected void initTracker() {
        ++this.currentTrackId;
        this.trackers.values().forEach(LifeTimeWorldTracker::initTracker);
    }

    @Override
    protected void printTrackingResult(class_2168 source, boolean realtime) {
        LifeTimeTrackerContext.commandSource.set(source);
        try {
            long ticks = this.sendTrackedTime(source, realtime);
            int count = this.trackers.values().stream().mapToInt(tracker -> tracker.print(source, ticks, null, null)).sum();
            if (count == 0) {
                Messenger.tell(source, this.tr("no_result", new Object[0]));
            }
        }
        catch (Exception e) {
            CarpetTISAdditionMod.LOGGER.error("Lifetime tracker report failed", (Throwable)e);
        }
    }

    public void sendUnknownEntity(class_2168 source, String entityTypeString) {
        Messenger.tell(source, Messenger.formatting(this.tr("unknown_entity_type", entityTypeString), "r"));
    }

    private void printTrackingResultSpecificImpl(class_2168 source, String entityTypeString, String detailModeString, boolean realtime) {
        LifeTimeTrackerContext.commandSource.set(source);
        Optional<class_1299<?>> entityTypeOptional = LifeTimeTrackerUtil.getEntityTypeFromName(entityTypeString);
        if (entityTypeOptional.isPresent()) {
            SpecificDetailMode detailMode = null;
            if (detailModeString != null) {
                try {
                    detailMode = SpecificDetailMode.fromString(detailModeString);
                }
                catch (IllegalArgumentException e) {
                    Messenger.tell(source, Messenger.formatting(this.tr("invalid_detail", detailModeString), "r"));
                    return;
                }
            }
            long ticks = this.sendTrackedTime(source, realtime);
            class_1299<?> entityType = entityTypeOptional.get();
            Messenger.tell(source, this.tr("specific_result", Messenger.entityType(entityType)));
            SpecificDetailMode finalDetailMode = detailMode;
            int count = this.trackers.values().stream().mapToInt(tracker -> tracker.print(source, ticks, entityType, finalDetailMode)).sum();
            if (count == 0) {
                Messenger.tell(source, this.tr("no_result", new Object[0]));
            }
        } else {
            this.sendUnknownEntity(source, entityTypeString);
        }
    }

    public int printTrackingResultSpecific(class_2168 source, String entityTypeString, String detailModeString, boolean realtime) {
        return this.doWhenTracking(source, () -> this.printTrackingResultSpecificImpl(source, entityTypeString, detailModeString, realtime));
    }

    protected int showHelp(class_2168 source) {
        class_2554 docLink = Messenger.formatting(this.tr("help.doc_link", new Object[0]), "t");
        Messenger.tell(source, Messenger.join(Messenger.s("\n"), Messenger.formatting(this.getTranslatedNameFull(), "wb"), this.tr("help.doc_summary", new Object[0]), this.tr("help.complete_doc_hint", Messenger.fancy(null, Messenger.formatting(this.tr("help.here", new Object[0]), "ut"), docLink, Messenger.ClickEvents.openUrl(docLink.getString())))));
        return 1;
    }
}

