/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.refresh;

import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.commands.AbstractCommand;
import carpettisaddition.commands.CommandTreeContext;
import carpettisaddition.commands.refresh.ChunkRefresher;
import carpettisaddition.commands.refresh.EuclideanDistanceHelper;
import carpettisaddition.mixins.command.refresh.ThreadedAnvilChunkStorageAccessor;
import carpettisaddition.translations.TISAdditionTranslations;
import carpettisaddition.utils.CarpetModUtil;
import carpettisaddition.utils.CommandUtils;
import carpettisaddition.utils.Messenger;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2554;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2635;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class RefreshCommand
extends AbstractCommand {
    private static final String NAME = "refresh";
    private static final RefreshCommand INSTANCE = new RefreshCommand();
    private final Set<class_3222> refreshingChunkPlayers = Collections.newSetFromMap(new WeakHashMap());

    public RefreshCommand() {
        super(NAME);
    }

    public static RefreshCommand getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerCommand(CommandTreeContext.Register context) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)NAME).requires(player -> CarpetModUtil.canUseCommand(player, CarpetTISAdditionSettings.commandRefresh))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"inventory").executes(c -> this.refreshSelfInventory((class_2168)c.getSource()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).requires(s -> CommandUtils.hasPermissionLevel(s, 2))).executes(c -> this.refreshSelectedPlayerInventory((class_2168)c.getSource(), class_2186.method_9312((CommandContext)c, (String)"players")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"chunk").executes(c -> this.refreshCurrentChunk((class_2168)c.getSource(), ((class_2168)c.getSource()).method_9207()))).then(class_2170.method_9247((String)"current").executes(c -> this.refreshCurrentChunk((class_2168)c.getSource(), ((class_2168)c.getSource()).method_9207())))).then(class_2170.method_9247((String)"all").executes(c -> this.refreshAllChunks((class_2168)c.getSource())))).then(class_2170.method_9247((String)"inrange").then(class_2170.method_9244((String)"chebyshevDistance", (ArgumentType)IntegerArgumentType.integer()).executes(c -> this.refreshChunksInRange((class_2168)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"chebyshevDistance")))))).then(class_2170.method_9247((String)"at").then(class_2170.method_9244((String)"chunkX", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"chunkZ", (ArgumentType)IntegerArgumentType.integer()).executes(c -> this.refreshSelectedChunk((class_2168)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"chunkX"), IntegerArgumentType.getInteger((CommandContext)c, (String)"chunkZ")))))));
        context.dispatcher.register(builder);
    }

    private void refreshPlayerInventory(class_2168 source, class_3222 player) {
        source.method_9211().method_3760().method_14594(player);
        Messenger.tell((class_1657)player, this.tr("inventory.done", new Object[0]));
    }

    private int refreshSelfInventory(class_2168 source) throws CommandSyntaxException {
        this.refreshPlayerInventory(source, source.method_9207());
        return 1;
    }

    private int refreshSelectedPlayerInventory(class_2168 source, Collection<class_3222> players) {
        players.forEach(player -> this.refreshPlayerInventory(source, (class_3222)player));
        return players.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int refreshChunks(class_2168 source, @Nullable class_1923 chunkPos, @Nullable Predicate<class_1923> predicate) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        class_3218 world = player.method_14220();
        Set<class_3222> set = this.refreshingChunkPlayers;
        synchronized (set) {
            if (this.refreshingChunkPlayers.contains(player)) {
                Messenger.tell(source, Messenger.formatting(this.tr("chunk.overloaded", new Object[0]), "r"));
                return 0;
            }
        }
        ThreadedAnvilChunkStorageAccessor chunkStorage = (ThreadedAnvilChunkStorageAccessor)world.method_14178().field_17254;
        MutableInt counter = new MutableInt(0);
        Consumer<class_2818> chunkRefresher = chunk -> {
            if (chunk != null) {
                new ChunkRefresher((class_2818)chunk).refreshFor(player);
                counter.add(1);
            }
        };
        Predicate<class_1923> inPlayerViewDistance = pos -> RefreshCommand.isChunkInsideRange(pos, player, chunkStorage.getWatchDistance());
        if (chunkPos != null) {
            if (inPlayerViewDistance.test(chunkPos)) {
                chunkRefresher.accept(world.method_8497(chunkPos.field_9181, chunkPos.field_9180));
            } else {
                Messenger.tell(source, Messenger.formatting(this.tr("chunk.too_far", new Object[0]), "r"));
            }
        } else {
            Objects.requireNonNull(predicate);
            chunkStorage.getCurrentChunkHolders().values().stream().filter(h -> inPlayerViewDistance.and(predicate).test(h.method_13994())).forEach(h -> chunkRefresher.accept(h.method_16144()));
            Set<class_3222> set2 = this.refreshingChunkPlayers;
            synchronized (set2) {
                this.refreshingChunkPlayers.add(player);
            }
        }
        class_2554 message = TISAdditionTranslations.translate(this.tr("chunk.done", counter.getValue()), player);
        player.field_13987.method_14369((class_2596)new class_2635((class_2561)message, class_2556.field_11735, class_156.field_25140), future -> {
            Set<class_3222> set = this.refreshingChunkPlayers;
            synchronized (set) {
                this.refreshingChunkPlayers.remove(player);
            }
        });
        return counter.getValue();
    }

    private int refreshSingleChunk(class_2168 source, @Nullable class_1923 chunkPos) throws CommandSyntaxException {
        return this.refreshChunks(source, chunkPos, null);
    }

    private int refreshAllChunks(class_2168 source) throws CommandSyntaxException {
        return this.refreshChunks(source, null, chunkPos -> true);
    }

    private int refreshCurrentChunk(class_2168 source, class_3222 player) throws CommandSyntaxException {
        return this.refreshSingleChunk(source, new class_1923(player.method_24515()));
    }

    private int refreshSelectedChunk(class_2168 source, int x, int z) throws CommandSyntaxException {
        return this.refreshSingleChunk(source, new class_1923(x, z));
    }

    private int refreshChunksInRange(class_2168 source, int distance) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        return this.refreshChunks(source, null, chunkPos -> RefreshCommand.isChunkInsideRange(chunkPos, player, distance));
    }

    private static boolean isChunkInsideRange(class_1923 chunkPos, class_3222 player, int distance) {
        class_4076 watchedSection = player.method_14232();
        return EuclideanDistanceHelper.isWithinDistance(chunkPos.field_9181, chunkPos.field_9180, watchedSection.method_18674(), watchedSection.method_18687(), distance);
    }
}

