/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming.enums;

import carpettisaddition.logging.loggers.microtiming.MicroTimingLoggerManager;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingUtil;
import carpettisaddition.mixins.logger.microtiming.misc.BlockAccessor;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.Messenger;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.class_2350;
import net.minecraft.class_2554;

public enum BlockUpdateType {
    BLOCK_UPDATE("BlockUpdates", new String[]{"Neighbor Changed", "Neighbor Update"}, Constants.BLOCK_UPDATE_ORDER),
    BLOCK_UPDATE_EXCEPT("BlockUpdates Except", new String[]{"Neighbor Changed Except", "Neighbor Update Except"}, Constants.BLOCK_UPDATE_ORDER),
    STATE_UPDATE("StateUpdates", new String[]{"Post Placement", "Update Shape"}, Constants.STATE_UPDATE_ORDER),
    COMPARATOR_UPDATE("ComparatorUpdates", new String[]{"Block update only to comparators"}, Constants.COMPARATOR_UPDATE_ORDER),
    SINGLE_BLOCK_UPDATE("SingleBlockUpdate", new String[]{"Block update to a single block"}, new class_2350[0]),
    SINGLE_STATE_UPDATE("SingleStateUpdate", new String[]{"State update to a single block"}, new class_2350[0]);

    private static final Translator translator;
    private final String name;
    private final String[] aka;
    private final class_2350[] updateOrder;

    private BlockUpdateType(String name, String[] aka, class_2350[] updateOrder) {
        this.name = name;
        this.aka = aka;
        this.updateOrder = updateOrder;
    }

    public class_2554 toText() {
        return translator.tr(this.name.toLowerCase().replace(' ', '_'), new Object[0]);
    }

    public class_2554 getUpdateOrderList(class_2350 skipSide) {
        int counter = 0;
        ArrayList builder = Lists.newArrayList();
        builder.add(translator.tr("aka", Joiner.on((String)", ").join((Object[])this.aka)));
        if (this.updateOrder.length > 0) {
            builder.add(Messenger.newLine());
            for (class_2350 direction : this.updateOrder) {
                if (skipSide == direction) continue;
                if (counter > 0) {
                    builder.add(Messenger.newLine());
                }
                builder.add(Messenger.s(String.format("%d. ", ++counter)));
                builder.add(MicroTimingUtil.getFormattedDirectionText(direction));
            }
        }
        if (skipSide != null) {
            builder.add(Messenger.s(String.format("\n%s: %s", translator.tr("except", new Object[0]), skipSide)));
        }
        return Messenger.c(builder.toArray(new Object[0]));
    }

    static {
        translator = MicroTimingLoggerManager.TRANSLATOR.getDerivedTranslator("block_update_type");
    }

    private static class Constants {
        private static final class_2350[] BLOCK_UPDATE_ORDER = new class_2350[]{class_2350.field_11039, class_2350.field_11034, class_2350.field_11033, class_2350.field_11036, class_2350.field_11043, class_2350.field_11035};
        private static final class_2350[] STATE_UPDATE_ORDER = BlockAccessor.getFACINGS();
        private static final class_2350[] COMPARATOR_UPDATE_ORDER = Lists.newArrayList((Iterator)class_2350.class_2353.field_11062.iterator()).toArray(new class_2350[0]);

        private Constants() {
        }
    }
}

