/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.network;

import carpettisaddition.CarpetTISAdditionMod;
import carpettisaddition.network.TISCMClientPacketHandler;
import carpettisaddition.utils.IdentifierUtils;
import com.google.common.collect.Maps;
import io.netty.buffer.Unpooled;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2960;

public class TISCMProtocol {
    public static final String ID = "tiscm";
    public static final String PLATFORM_NAME = "Carpet TIS Addition";
    public static final String PLATFORM_VERSION = CarpetTISAdditionMod.getVersion();
    public static final class_2960 CHANNEL = IdentifierUtils.of("tiscm", "network/v1");

    private static <T> T makePacket(BiFunction<class_2960, class_2540, T> packetConstructor, PacketId packetId, Consumer<class_2487> payloadBuilder) {
        class_2487 nbt = new class_2487();
        payloadBuilder.accept(nbt);
        class_2540 packetByteBuf = new class_2540(Unpooled.buffer());
        packetByteBuf.method_10814(packetId.getId());
        packetByteBuf.method_10794(nbt);
        return packetConstructor.apply(CHANNEL, packetByteBuf);
    }

    private static <T extends PacketId> Map<String, T> createIdMap(T[] values) {
        LinkedHashMap idMap = Maps.newLinkedHashMap();
        for (T value : values) {
            idMap.put(value.getId(), value);
        }
        return idMap;
    }

    public static interface PacketId {
        public String name();

        default public String getId() {
            return this.name().toLowerCase();
        }
    }

    public static enum S2C implements PacketId
    {
        HELLO(true),
        SUPPORTED_C2S_PACKETS(true),
        MSPT_METRICS_SAMPLE,
        SPEED_TEST_DOWNLOAD_PAYLOAD,
        SPEED_TEST_UPLOAD_REQUEST,
        SPEED_TEST_PING,
        SPEED_TEST_ABORT;

        public static final Map<String, S2C> ID_MAP;
        public final boolean isHandshake;

        private S2C(boolean isHandshake) {
            this.isHandshake = isHandshake;
        }

        private S2C() {
            this(false);
        }

        public static Optional<S2C> fromId(String id) {
            return Optional.ofNullable(ID_MAP.get(id));
        }

        public class_2658 packet(Consumer<class_2487> payloadBuilder) {
            return TISCMProtocol.makePacket(class_2658::new, this, payloadBuilder);
        }

        static {
            ID_MAP = TISCMProtocol.createIdMap((PacketId[])S2C.values());
        }
    }

    public static enum C2S implements PacketId
    {
        HI(true),
        SUPPORTED_S2C_PACKETS(true),
        SPEED_TEST_UPLOAD_PAYLOAD,
        SPEED_TEST_PING;

        public static final Map<String, C2S> ID_MAP;
        public final boolean isHandshake;

        private C2S(boolean isHandshake) {
            this.isHandshake = isHandshake;
        }

        private C2S() {
            this(false);
        }

        public static Optional<C2S> fromId(String id) {
            return Optional.ofNullable(ID_MAP.get(id));
        }

        public class_2817 packet(Consumer<class_2487> payloadBuilder) {
            return TISCMProtocol.makePacket(class_2817::new, this, payloadBuilder);
        }

        public boolean isSupported() {
            return TISCMClientPacketHandler.getInstance().doesServerSupport(this);
        }

        static {
            ID_MAP = TISCMProtocol.createIdMap((PacketId[])C2S.values());
        }
    }
}

