/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.network;

import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.commands.speedtest.SpeedTestCommand;
import carpettisaddition.network.HandlerContext;
import carpettisaddition.network.TISCMCustomPayload;
import carpettisaddition.network.TISCMProtocol;
import carpettisaddition.utils.NbtUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_3244;
import org.apache.logging.log4j.Logger;

public class TISCMServerPacketHandler {
    private static final Logger LOGGER = CarpetTISAdditionServer.LOGGER;
    private static final TISCMServerPacketHandler INSTANCE = new TISCMServerPacketHandler();
    private final Map<TISCMProtocol.C2S, Consumer<HandlerContext.C2S>> handlers = new EnumMap<TISCMProtocol.C2S, Consumer<HandlerContext.C2S>>(TISCMProtocol.C2S.class);
    private final Map<TISCMProtocol.C2S, Consumer<HandlerContext.C2S>> asyncHandlers = new EnumMap<TISCMProtocol.C2S, Consumer<HandlerContext.C2S>>(TISCMProtocol.C2S.class);
    private final Map<class_3244, Set<TISCMProtocol.S2C>> clientSupportedPacketsMap = Maps.newLinkedHashMap();

    private TISCMServerPacketHandler() {
        this.handlers.put(TISCMProtocol.C2S.HI, this::handleHi);
        this.handlers.put(TISCMProtocol.C2S.SUPPORTED_S2C_PACKETS, this::handleSupportPackets);
        this.asyncHandlers.put(TISCMProtocol.C2S.SPEED_TEST_UPLOAD_PAYLOAD, SpeedTestCommand.getInstance()::handleClientSpeedTestUploadPayload);
        this.asyncHandlers.put(TISCMProtocol.C2S.SPEED_TEST_PING, SpeedTestCommand.getInstance()::handleClientPing);
        HashSet missingIds = Sets.newHashSet();
        missingIds.addAll(TISCMProtocol.C2S.ID_MAP.values());
        missingIds.removeAll(this.handlers.keySet());
        missingIds.removeAll(this.asyncHandlers.keySet());
        if (!missingIds.isEmpty()) {
            throw new RuntimeException("TISCMServerPacketDispatcher doesn't handle all C2S packets: " + String.valueOf(missingIds));
        }
    }

    public static TISCMServerPacketHandler getInstance() {
        return INSTANCE;
    }

    public void dispatch(class_3244 networkHandler, TISCMCustomPayload tiscmCustomPayload) {
        HandlerContext.C2S ctx = new HandlerContext.C2S(networkHandler, tiscmCustomPayload.getNbt());
        Optional<TISCMProtocol.C2S> packetId = TISCMProtocol.C2S.fromId(tiscmCustomPayload.getPacketId());
        packetId.map(this.asyncHandlers::get).ifPresent(handler -> handler.accept(ctx));
        ctx.runSynced(() -> packetId.map(this.handlers::get).ifPresent(handler -> handler.accept(ctx)));
    }

    public void onPlayerDisconnected(class_3244 networkHandler) {
        this.clientSupportedPacketsMap.remove(networkHandler);
    }

    public boolean doesClientSupport(class_3244 networkHandler, TISCMProtocol.S2C packetId) {
        if (packetId.isHandshake) {
            return true;
        }
        Set<TISCMProtocol.S2C> packetIds = this.clientSupportedPacketsMap.get(networkHandler);
        return packetIds != null && packetIds.contains(packetId);
    }

    public void sendPacket(class_3244 networkHandler, TISCMProtocol.S2C packetId, Consumer<class_2487> payloadBuilder) {
        this.sendPacket(networkHandler, packetId, payloadBuilder, () -> {});
    }

    public void sendPacket(class_3244 networkHandler, TISCMProtocol.S2C packetId, Consumer<class_2487> payloadBuilder, Runnable doneCallback) {
        if (this.doesClientSupport(networkHandler, packetId)) {
            networkHandler.method_14369((class_2596)packetId.packet(payloadBuilder), f -> doneCallback.run());
        }
    }

    public void broadcast(TISCMProtocol.S2C packetId, Consumer<class_2487> payloadBuilder) {
        this.clientSupportedPacketsMap.forEach((serverPlayNetworkHandler, supportedPackets) -> this.sendPacket((class_3244)serverPlayNetworkHandler, packetId, payloadBuilder));
    }

    public void handleHi(HandlerContext.C2S ctx) {
        String platformName = NbtUtils.getStringOrEmpty(ctx.payload, "platform_name");
        String platformVersion = NbtUtils.getStringOrEmpty(ctx.payload, "platform_version");
        LOGGER.info("Player {} connected with TISCM protocol support ({} @ {})", (Object)ctx.playerName, (Object)platformName, (Object)platformVersion);
        ctx.send(TISCMProtocol.S2C.HELLO, nbt -> {
            nbt.method_10582("platform_name", "Carpet TIS Addition");
            nbt.method_10582("platform_version", TISCMProtocol.PLATFORM_VERSION);
        });
        ArrayList ids = Lists.newArrayList(TISCMProtocol.C2S.ID_MAP.keySet());
        ctx.send(TISCMProtocol.S2C.SUPPORTED_C2S_PACKETS, nbt -> nbt.method_10566("supported_c2s_packets", (class_2520)NbtUtils.stringList2Nbt(ids)));
    }

    public void handleSupportPackets(HandlerContext.C2S ctx) {
        List<String> ids = NbtUtils.nbt2StringList(NbtUtils.getNbtOrEmpty(ctx.payload, "supported_s2c_packets"));
        LOGGER.debug("Player {} clientside supported TISCM S2C packet ids: {}", (Object)ctx.playerName, ids);
        Set packetIds = ids.stream().map(TISCMProtocol.S2C::fromId).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        this.clientSupportedPacketsMap.put(ctx.networkHandler, packetIds);
    }
}

