/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Nullable;

public class NetworkUtils {
    private static final int TAG_ID_COMPOUND = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NbtStyle guessNbtStyle(class_2540 buf) {
        int n = buf.readableBytes();
        int prevReaderIndex = buf.readerIndex();
        try {
            if (n < 2) {
                NbtStyle nbtStyle = NbtStyle.UNKNOWN;
                return nbtStyle;
            }
            byte typeId = buf.readByte();
            if (typeId != 10) {
                NbtStyle nbtStyle = NbtStyle.UNKNOWN;
                return nbtStyle;
            }
            if (n == 2) {
                if (buf.readByte() == 0) {
                    NbtStyle nbtStyle = NbtStyle.NEW;
                    return nbtStyle;
                }
                NbtStyle nbtStyle = NbtStyle.UNKNOWN;
                return nbtStyle;
            }
            byte[] bytes = new byte[2];
            buf.readBytes(bytes);
            if (bytes[0] == 0 && bytes[1] == 0) {
                NbtStyle nbtStyle = NbtStyle.OLD;
                return nbtStyle;
            }
            if (0 <= bytes[0] && bytes[0] < 13) {
                NbtStyle nbtStyle = NbtStyle.NEW;
                return nbtStyle;
            }
        }
        finally {
            buf.readerIndex(prevReaderIndex);
        }
        return NbtStyle.UNKNOWN;
    }

    @Nullable
    public static class_2487 readNbt(class_2540 buf) {
        NbtStyle nbtStyle = NetworkUtils.guessNbtStyle(buf);
        if (NbtStyle.CURRENT == NbtStyle.OLD && nbtStyle == NbtStyle.NEW) {
            int prevReaderIndex = buf.readerIndex();
            class_2540 tweakedBuf = new class_2540(Unpooled.buffer());
            tweakedBuf.writeByte((int)buf.readByte());
            tweakedBuf.writeByte(0).writeByte(0);
            tweakedBuf.writeBytes((ByteBuf)buf);
            buf.readerIndex(prevReaderIndex);
            class_2487 nbt = tweakedBuf.method_10798();
            int n = tweakedBuf.readerIndex();
            buf.readBytes(Math.max(0, n - 2));
            return nbt;
        }
        if (NbtStyle.CURRENT == NbtStyle.NEW && nbtStyle == NbtStyle.OLD) {
            int prevReaderIndex = buf.readerIndex();
            class_2540 tweakedBuf = new class_2540(Unpooled.buffer());
            tweakedBuf.writeByte((int)buf.readByte());
            buf.readBytes(2);
            tweakedBuf.writeBytes((ByteBuf)buf);
            buf.readerIndex(prevReaderIndex);
            class_2487 nbt = tweakedBuf.method_10798();
            int n = tweakedBuf.readerIndex();
            buf.readBytes(Math.max(0, n > 1 ? n + 2 : n));
            return nbt;
        }
        return buf.method_10798();
    }

    public static enum NbtStyle {
        UNKNOWN,
        OLD,
        NEW;

        public static final NbtStyle CURRENT;

        static {
            CURRENT = OLD;
        }
    }
}

