/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.info.world;

import carpettisaddition.commands.CommandTreeContext;
import carpettisaddition.commands.info.InfoSubcommand;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.compat.DimensionWrapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2554;
import net.minecraft.class_3218;
import net.minecraft.class_5268;

public class InfoWorldCommand
extends InfoSubcommand {
    private static final InfoWorldCommand INSTANCE = new InfoWorldCommand();

    public static InfoWorldCommand getInstance() {
        return INSTANCE;
    }

    @Override
    public void extendCommand(CommandTreeContext.Node context) {
        context.node.then(class_2170.method_9247((String)"ticking_order").executes(c -> this.showWorldTickOrder((class_2168)c.getSource()))).then(class_2170.method_9247((String)"weather").executes(c -> this.showWeather((class_2168)c.getSource())));
    }

    private int showWorldTickOrder(class_2168 source) {
        ArrayList worlds = Lists.newArrayList((Iterable)source.method_9211().method_3738());
        Messenger.tell(source, this.tr("ticking_order", worlds.size()));
        int order = 0;
        for (class_1937 world : worlds) {
            Messenger.tell(source, Messenger.c("g " + ++order + ". ", Messenger.dimension(DimensionWrapper.of(world))));
        }
        return 1;
    }

    private int showWeather(class_2168 source) {
        class_3218 world = source.method_9225();
        class_5268 worldInfo = (class_5268)world.method_8401();
        int clearTime = worldInfo.method_155();
        boolean raining = worldInfo.method_156();
        boolean thundering = worldInfo.method_203();
        int rainTime = worldInfo.method_190();
        int thunderTime = worldInfo.method_145();
        BiFunction<String, Object, class_2554> itemPrint = (key, value) -> Messenger.c(Messenger.hover(this.tr("weather.data." + key, new Object[0]), Messenger.s(key)), Messenger.s((Object)" = ", class_124.field_1080), Messenger.colored(value));
        Function<Integer, class_2554> toMin = ticks -> Messenger.c(Messenger.hover(Messenger.s(String.format("%.1f", (double)ticks.intValue() / 20.0 / 60.0)), Messenger.s(ticks + " ticks")), "g min");
        BiFunction<class_2554, Integer, class_2554> durationPrint = (name, ticks) -> Messenger.c(name, "g : ", toMin.apply((Integer)ticks));
        Messenger.tell(source, Messenger.s(""));
        Messenger.tell(source, Messenger.c("g ======= ", this.tr("weather.data.title", new Object[0]), "g  ======="));
        Messenger.tell(source, itemPrint.apply("clearWeatherTime", clearTime));
        Messenger.tell(source, itemPrint.apply("rainTime", rainTime));
        Messenger.tell(source, itemPrint.apply("thunderTime", thunderTime));
        Messenger.tell(source, itemPrint.apply("raining", raining));
        Messenger.tell(source, itemPrint.apply("thundering", thundering));
        Messenger.tell(source, Messenger.s(""));
        Messenger.tell(source, Messenger.c("g ======= ", this.tr("weather.forecast.title", new Object[0]), "g  ======="));
        if (clearTime > 0) {
            Messenger.tell(source, durationPrint.apply(this.tr("weather.forecast.clear_sky_duration", new Object[0]), clearTime));
        } else if (raining && thundering) {
            Messenger.tell(source, this.tr("weather.forecast.current", Messenger.formatting(this.tr("weather.weathers.thundering", new Object[0]), class_124.field_1076)));
            Messenger.tell(source, durationPrint.apply(this.tr("weather.forecast.rain_duration", new Object[0]), rainTime));
            Messenger.tell(source, durationPrint.apply(this.tr("weather.forecast.thunder_duration", new Object[0]), Math.min(rainTime, thunderTime)));
        } else if (raining && !thundering) {
            Messenger.tell(source, this.tr("weather.forecast.current", Messenger.formatting(this.tr("weather.weathers.raining", new Object[0]), class_124.field_1078)));
            Messenger.tell(source, durationPrint.apply(this.tr("weather.forecast.rain_duration", new Object[0]), rainTime));
            if (thunderTime < rainTime) {
                Messenger.tell(source, this.tr("weather.forecast.thunder_in", toMin.apply(thunderTime)));
            } else {
                Messenger.tell(source, this.tr("weather.forecast.no_thunder", new Object[0]));
            }
        } else {
            Messenger.tell(source, this.tr("weather.forecast.current", Messenger.formatting(this.tr("weather.weathers.clear_sky", new Object[0]), class_124.field_1068)));
            Messenger.tell(source, this.tr("weather.forecast.rain_in", toMin.apply(rainTime)));
            if (thundering) {
                if (rainTime < thunderTime) {
                    Messenger.tell(source, this.tr("weather.forecast.rain_in.with_thunder", toMin.apply(thunderTime - rainTime)));
                } else {
                    Messenger.tell(source, this.tr("weather.forecast.rain_in.thunder_unknown", toMin.apply(thunderTime)));
                }
            } else if (rainTime < thunderTime) {
                Messenger.tell(source, this.tr("weather.forecast.rain_in.no_thunder_for_now", toMin.apply(thunderTime)));
            } else {
                Messenger.tell(source, this.tr("weather.forecast.rain_in.maybe_thunder", toMin.apply(thunderTime)));
            }
        }
        return 1;
    }
}

