/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.helpers.carpet.shape;

import carpet.script.utils.ShapeDispatcher;
import carpet.script.value.NumericValue;
import carpet.script.value.Value;
import carpettisaddition.mixins.carpet.shape.ExpiringShapeInvoker;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class ShapeHolder<T extends ShapeDispatcher.ExpiringShape> {
    public final T shape;
    public final Map<String, Value> params;
    public final Map<String, Value> emptyParams;

    public ShapeHolder(T shape, Map<String, Value> params) {
        this.shape = shape;
        this.params = params;
        this.emptyParams = Maps.newHashMap(this.params);
        this.emptyParams.put("duration", (Value)new NumericValue(0L));
        this.updateShape();
    }

    private void updateShape() {
        ((ExpiringShapeInvoker)this.shape).callInit(this.params);
    }

    public Pair<ShapeDispatcher.ExpiringShape, Map<String, Value>> toPair(boolean display) {
        return Pair.of(this.shape, display ? this.params : this.emptyParams);
    }

    public void setValue(String key, Value value) {
        this.params.put(key, value);
        this.emptyParams.put(key, value);
        this.updateShape();
    }
}

