/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.helpers.rule.yeetUpdateSuppressionCrash;

import carpettisaddition.helpers.rule.yeetUpdateSuppressionCrash.UpdateSuppressionContext;
import carpettisaddition.helpers.rule.yeetUpdateSuppressionCrash.UpdateSuppressionException;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;

public class UpdateSuppressionExceptions {
    @Nullable
    public static UpdateSuppressionException createWrapper(Throwable cause, @Nullable class_1937 world, class_2338 pos) {
        if (cause instanceof StackOverflowError) {
            return new StackOverflowSuppression(cause, world, pos);
        }
        if (cause instanceof ClassCastException) {
            return new ClassCastSuppression(cause, world, pos);
        }
        if (cause instanceof OutOfMemoryError) {
            return new OutOfMemorySuppression(cause, world, pos);
        }
        if (cause instanceof IllegalArgumentException) {
            return new IllegalArgumentSuppression(cause, world, pos);
        }
        return null;
    }

    public static void noop() {
        UpdateSuppressionException.class.getClass();
        StackOverflowSuppression.class.getClass();
        ClassCastSuppression.class.getClass();
        OutOfMemorySuppression.class.getClass();
        IllegalArgumentSuppression.class.getClass();
    }

    public static class StackOverflowSuppression
    extends StackOverflowError
    implements UpdateSuppressionException {
        private final UpdateSuppressionContext context;

        public StackOverflowSuppression(Throwable cause, @Nullable class_1937 world, class_2338 pos) {
            this.context = new UpdateSuppressionContext(cause, world, pos);
        }

        @Override
        public synchronized Throwable getCause() {
            return this.context.getCause();
        }

        @Override
        public UpdateSuppressionContext getSuppressionContext() {
            return this.context;
        }
    }

    public static class ClassCastSuppression
    extends ClassCastException
    implements UpdateSuppressionException {
        private final UpdateSuppressionContext context;

        public ClassCastSuppression(Throwable cause, @Nullable class_1937 world, class_2338 pos) {
            this.context = new UpdateSuppressionContext(cause, world, pos);
        }

        @Override
        public synchronized Throwable getCause() {
            return this.context.getCause();
        }

        @Override
        public UpdateSuppressionContext getSuppressionContext() {
            return this.context;
        }
    }

    public static class OutOfMemorySuppression
    extends OutOfMemoryError
    implements UpdateSuppressionException {
        private final UpdateSuppressionContext context;

        public OutOfMemorySuppression(Throwable cause, @Nullable class_1937 world, class_2338 pos) {
            this.context = new UpdateSuppressionContext(cause, world, pos);
        }

        @Override
        public synchronized Throwable getCause() {
            return this.context.getCause();
        }

        @Override
        public UpdateSuppressionContext getSuppressionContext() {
            return this.context;
        }
    }

    public static class IllegalArgumentSuppression
    extends IllegalArgumentException
    implements UpdateSuppressionException {
        private final UpdateSuppressionContext context;

        public IllegalArgumentSuppression(Throwable cause, @Nullable class_1937 world, class_2338 pos) {
            this.context = new UpdateSuppressionContext(cause, world, pos);
        }

        @Override
        public synchronized Throwable getCause() {
            return this.context.getCause();
        }

        @Override
        public UpdateSuppressionContext getSuppressionContext() {
            return this.context;
        }
    }
}

