/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming;

import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.logging.TISAdditionLoggerRegistry;
import carpettisaddition.logging.loggers.AbstractLogger;
import carpettisaddition.logging.loggers.microtiming.MicroTimingLogger;
import carpettisaddition.logging.loggers.microtiming.enums.BlockUpdateType;
import carpettisaddition.logging.loggers.microtiming.enums.EventType;
import carpettisaddition.logging.loggers.microtiming.enums.TickStage;
import carpettisaddition.logging.loggers.microtiming.events.BaseEvent;
import carpettisaddition.logging.loggers.microtiming.events.BlockReplaceEvent;
import carpettisaddition.logging.loggers.microtiming.events.BlockStateChangeEvent;
import carpettisaddition.logging.loggers.microtiming.events.DetectBlockUpdateEvent;
import carpettisaddition.logging.loggers.microtiming.events.EmitBlockUpdateEvent;
import carpettisaddition.logging.loggers.microtiming.events.EmitBlockUpdateRedstoneDustEvent;
import carpettisaddition.logging.loggers.microtiming.events.EventSource;
import carpettisaddition.logging.loggers.microtiming.events.ExecuteBlockEventEvent;
import carpettisaddition.logging.loggers.microtiming.events.ExecuteTileTickEvent;
import carpettisaddition.logging.loggers.microtiming.events.ScheduleBlockEventEvent;
import carpettisaddition.logging.loggers.microtiming.events.ScheduleBlockUpdateEvent;
import carpettisaddition.logging.loggers.microtiming.events.ScheduleTileTickEvent;
import carpettisaddition.logging.loggers.microtiming.interfaces.ServerWorldWithMicroTimingLogger;
import carpettisaddition.logging.loggers.microtiming.marker.MicroTimingMarkerManager;
import carpettisaddition.logging.loggers.microtiming.tickphase.TickPhase;
import carpettisaddition.logging.loggers.microtiming.tickphase.substages.AbstractSubStage;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingContext;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingUtil;
import carpettisaddition.script.MicroTimingEvent;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.ItemUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1919;
import net.minecraft.class_1937;
import net.minecraft.class_1953;
import net.minecraft.class_1954;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2554;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MicroTimingLoggerManager {
    private static MicroTimingLoggerManager instance;
    private final Map<class_3218, MicroTimingLogger> loggers = new Reference2ObjectArrayMap();
    public static final Translator TRANSLATOR;
    private TickPhase offWorldTickPhase = new TickPhase(TickStage.UNKNOWN, null);
    public ThreadLocal<class_3218> currentWorld = ThreadLocal.withInitial(() -> null);
    public static final Set<class_2338> trackedPositions;

    public static class_2554 tr(String key, Object ... args) {
        return TRANSLATOR.tr(key, args);
    }

    public MicroTimingLoggerManager(MinecraftServer minecraftServer) {
        for (class_3218 world : minecraftServer.method_3738()) {
            this.loggers.put(world, ((ServerWorldWithMicroTimingLogger)world).getMicroTimingLogger());
        }
    }

    public Map<class_3218, MicroTimingLogger> getLoggers() {
        return this.loggers;
    }

    public static boolean isLoggerActivated() {
        if (CarpetTISAdditionSettings.microTiming && instance != null) {
            if (!trackedPositions.isEmpty()) {
                return true;
            }
            return TISAdditionLoggerRegistry.__microTiming;
        }
        return false;
    }

    public static void attachServer(MinecraftServer minecraftServer) {
        instance = new MicroTimingLoggerManager(minecraftServer);
    }

    public static void detachServer() {
        instance = null;
    }

    @NotNull
    public static MicroTimingLoggerManager getInstance() {
        if (instance == null) {
            throw new RuntimeException("MicroTimingLoggerManager not attached");
        }
        return instance;
    }

    private static Optional<MicroTimingLogger> getWorldLogger(class_1937 world) {
        if (instance != null && world instanceof class_3218) {
            return Optional.of(((ServerWorldWithMicroTimingLogger)world).getMicroTimingLogger());
        }
        return Optional.empty();
    }

    public static void dispatchScarpetEvent(class_1937 world, class_2338 pos, Supplier<BaseEvent> supplier) {
        if (CarpetTISAdditionSettings.microTiming && trackedPositions.contains(pos)) {
            MicroTimingEvent.determineBlockEvent(supplier.get(), world, pos);
        }
    }

    private static void onEvent(MicroTimingContext context) {
        MicroTimingLoggerManager.dispatchScarpetEvent(context.getWorld(), context.getBlockPos(), context.getEventSupplier());
        MicroTimingLoggerManager.getWorldLogger(context.getWorld()).ifPresent(logger -> logger.addMessage(context));
    }

    public static void onScheduleBlockUpdate(class_1937 world, class_2338 pos, class_2248 sourceBlock, BlockUpdateType updateType, class_2350 exceptSide) {
        if (!MicroTimingLoggerManager.isLoggerActivated()) {
            return;
        }
        MicroTimingLoggerManager.onEvent(MicroTimingContext.create().withWorld(world).withBlockPos(pos).withEventSupplier(() -> new ScheduleBlockUpdateEvent(sourceBlock, updateType, exceptSide)).withWoolGetter(MicroTimingUtil::blockUpdateColorGetter));
    }

    public static void onBlockUpdate(class_1937 world, class_2338 pos, class_2248 sourceBlock, BlockUpdateType updateType, class_2350 exceptSide, EventType eventType) {
        if (!MicroTimingLoggerManager.isLoggerActivated()) {
            return;
        }
        MicroTimingLoggerManager.onEvent(MicroTimingContext.create().withWorld(world).withBlockPos(pos).withEventSupplier(() -> new DetectBlockUpdateEvent(eventType, sourceBlock, updateType, exceptSide)).withWoolGetter(MicroTimingUtil::blockUpdateColorGetter));
    }

    public static void onSetBlockState(class_1937 world, class_2338 pos, class_2680 oldState, class_2680 newState, Boolean returnValue, int flags, EventType eventType) {
        if (!MicroTimingLoggerManager.isLoggerActivated()) {
            return;
        }
        if (oldState.method_26204() == newState.method_26204()) {
            class_1767 color = null;
            ArrayList changes = Lists.newArrayList();
            for (class_2769 property : newState.method_28501()) {
                if (color == null) {
                    Optional<class_1767> optionalDyeColor = MicroTimingUtil.defaultColorGetter(world, pos);
                    if (!optionalDyeColor.isPresent()) break;
                    color = optionalDyeColor.get();
                }
                if (oldState.method_11654(property) == newState.method_11654(property)) continue;
                changes.add(new BlockStateChangeEvent.PropertyChange(property, oldState.method_11654(property), newState.method_11654(property)));
            }
            if (!changes.isEmpty()) {
                MicroTimingLoggerManager.onEvent(MicroTimingContext.create().withWorld(world).withBlockPos(pos).withColor(color).withEventSupplier(() -> {
                    BlockStateChangeEvent event = new BlockStateChangeEvent(eventType, oldState, newState, returnValue, flags);
                    event.setChanges(changes);
                    return event;
                }));
            }
        } else {
            MicroTimingLoggerManager.onEvent(MicroTimingContext.create().withWorld(world).withBlockPos(pos).withEventSupplier(() -> new BlockReplaceEvent(eventType, oldState, newState, returnValue, flags)).withWoolGetter(MicroTimingUtil::defaultColorGetter));
        }
    }

    public static void onExecuteTileTickEvent(class_1937 world, class_1954<?> tileTickEvent, EventType eventType) {
        if (!MicroTimingLoggerManager.isLoggerActivated()) {
            return;
        }
        class_2338 pos = tileTickEvent.field_9322;
        ExecuteTileTickEvent.createFrom(eventType, tileTickEvent).ifPresent(event -> MicroTimingLoggerManager.onEvent(MicroTimingContext.create().withWorld(world).withBlockPos(pos).withEvent((BaseEvent)event)));
    }

    public static void onScheduleTileTickEvent(class_1937 world, Object object, class_2338 pos, int delay, class_1953 priority, Boolean success) {
        if (!MicroTimingLoggerManager.isLoggerActivated()) {
            return;
        }
        EventSource.fromObject(object).ifPresent(eventSource -> MicroTimingLoggerManager.onEvent(MicroTimingContext.create().withWorld(world).withBlockPos(pos).withEvent(new ScheduleTileTickEvent((EventSource)eventSource, delay, priority, success))));
    }

    public static void onExecuteBlockEvent(class_1937 world, class_1919 blockAction, Boolean returnValue, ExecuteBlockEventEvent.FailInfo failInfo, EventType eventType) {
        if (!MicroTimingLoggerManager.isLoggerActivated()) {
            return;
        }
        MicroTimingLoggerManager.onEvent(MicroTimingContext.create().withWorld(world).withBlockPos(blockAction.method_8306()).withEvent(new ExecuteBlockEventEvent(eventType, blockAction, returnValue, failInfo)));
    }

    public static void onScheduleBlockEvent(class_1937 world, class_1919 blockAction, boolean success) {
        if (!MicroTimingLoggerManager.isLoggerActivated()) {
            return;
        }
        MicroTimingLoggerManager.onEvent(MicroTimingContext.create().withWorld(world).withBlockPos(blockAction.method_8306()).withEvent(new ScheduleBlockEventEvent(blockAction, success)));
    }

    public static void onEmitBlockUpdate(class_1937 world, class_2248 block, class_2338 pos, EventType eventType, String methodName) {
        if (!MicroTimingLoggerManager.isLoggerActivated()) {
            return;
        }
        MicroTimingLoggerManager.onEvent(MicroTimingContext.create().withWorld(world).withBlockPos(pos).withEvent(new EmitBlockUpdateEvent(eventType, block, methodName)));
    }

    public static void onEmitBlockUpdateRedstoneDust(class_1937 world, class_2248 block, class_2338 pos, EventType eventType, String methodName, Collection<class_2338> updateOrder) {
        if (!MicroTimingLoggerManager.isLoggerActivated()) {
            return;
        }
        MicroTimingLoggerManager.onEvent(MicroTimingContext.create().withWorld(world).withBlockPos(pos).withEvent(new EmitBlockUpdateRedstoneDustEvent(eventType, block, methodName, pos, updateOrder)));
    }

    public static void setTickStage(class_1937 world, @NotNull TickStage stage) {
        MicroTimingLoggerManager.getWorldLogger(world).ifPresent(logger -> logger.setTickStage(stage));
    }

    public static void setTickStage(@NotNull TickStage stage) {
        if (instance != null) {
            for (MicroTimingLogger logger : MicroTimingLoggerManager.instance.loggers.values()) {
                logger.setTickStage(stage);
            }
            MicroTimingLoggerManager.instance.offWorldTickPhase = MicroTimingLoggerManager.instance.offWorldTickPhase.withMainStage(stage);
        }
    }

    public static void setTickStageDetail(class_1937 world, @Nullable String detail) {
        MicroTimingLoggerManager.getWorldLogger(world).ifPresent(logger -> logger.setTickStageDetail(detail));
    }

    public static void setSubTickStage(class_1937 world, AbstractSubStage stage) {
        MicroTimingLoggerManager.getWorldLogger(world).ifPresent(logger -> logger.setSubTickStage(stage));
    }

    public static void setSubTickStage(AbstractSubStage stage) {
        if (instance != null) {
            for (MicroTimingLogger logger : MicroTimingLoggerManager.instance.loggers.values()) {
                logger.setSubTickStage(stage);
            }
            MicroTimingLoggerManager.instance.offWorldTickPhase = MicroTimingLoggerManager.instance.offWorldTickPhase.withSubStage(stage);
        }
    }

    private synchronized void flush() {
        for (MicroTimingLogger logger : this.loggers.values()) {
            logger.flushMessages();
        }
    }

    public static void setCurrentWorld(class_3218 world) {
        MicroTimingLoggerManager.getInstance().currentWorld.set(world);
    }

    @Nullable
    public static class_3218 getCurrentWorld() {
        return MicroTimingLoggerManager.getInstance().currentWorld.get();
    }

    @Nullable
    public static TickPhase getOffWorldTickPhase() {
        return MicroTimingLoggerManager.getInstance().offWorldTickPhase;
    }

    public static void flushMessages() {
        if (instance != null && MicroTimingLoggerManager.isLoggerActivated()) {
            instance.flush();
        }
    }

    public static boolean onPlayerRightClick(class_1657 playerEntity, class_1268 hand, class_2338 blockPos) {
        if (MicroTimingUtil.isMarkerEnabled() && playerEntity instanceof class_3222 && hand == class_1268.field_5808 && MicroTimingUtil.isPlayerSubscribed(playerEntity)) {
            class_1799 itemStack = playerEntity.method_6047();
            class_1792 holdingItem = itemStack.method_7909();
            if (holdingItem instanceof class_1769) {
                class_2554 name = null;
                if (ItemUtils.hasCustomName(itemStack)) {
                    name = (class_2554)itemStack.method_7964();
                }
                MicroTimingMarkerManager.getInstance().addMarker(playerEntity, blockPos, ((class_1769)holdingItem).method_7802(), name);
                return true;
            }
            if (holdingItem == class_1802.field_8777) {
                return MicroTimingMarkerManager.getInstance().tweakMarkerMobility(playerEntity, blockPos);
            }
        }
        return false;
    }

    public static void moveMarker(class_1937 world, class_2338 blockPos, class_2350 direction) {
        if (MicroTimingUtil.isMarkerEnabled()) {
            MicroTimingMarkerManager.getInstance().moveMarker(world, blockPos, direction);
        }
    }

    static {
        TRANSLATOR = new AbstractLogger("microTiming", false){}.getTranslator();
        trackedPositions = Sets.newHashSet();
    }
}

