/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.logger.lightqueue;

import carpettisaddition.logging.loggers.lightqueue.IServerLightingProvider;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.class_3227;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3227.class})
public abstract class ServerLightingProviderMixin
implements IServerLightingProvider {
    private final AtomicLong enqueuedTaskCount = new AtomicLong();
    private final AtomicLong executedTaskCount = new AtomicLong();
    private final AtomicLong queueSize = new AtomicLong();

    @Inject(method={"enqueue(IILjava/util/function/IntSupplier;Lnet/minecraft/server/world/ServerLightingProvider$Stage;Ljava/lang/Runnable;)V"}, at={@At(value="TAIL")})
    private void onEnqueuedLightUpdateTask(CallbackInfo ci) {
        this.enqueuedTaskCount.getAndIncrement();
        this.queueSize.getAndIncrement();
    }

    @Override
    public void onExecutedLightUpdates() {
        this.executedTaskCount.getAndIncrement();
        this.queueSize.getAndDecrement();
    }

    @Inject(method={"runTasks"}, at={@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/objects/ObjectListIterator;remove()V", remap=false)})
    private void onExecutedLightUpdates(CallbackInfo ci) {
        this.onExecutedLightUpdates();
    }

    @Override
    public long getEnqueuedTaskCountAndClean() {
        return this.enqueuedTaskCount.getAndSet(0L);
    }

    @Override
    public long getExecutedTaskCountAndClean() {
        return this.executedTaskCount.getAndSet(0L);
    }

    @Override
    public long getQueueSize() {
        return this.queueSize.get();
    }
}

