/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.lifetime.filter;

import carpettisaddition.commands.lifetime.LifeTimeTracker;
import carpettisaddition.commands.lifetime.utils.LifeTimeTrackerUtil;
import carpettisaddition.mixins.utils.entityfilter.EntitySelectorAccessor;
import carpettisaddition.translations.TranslationContext;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.entityfilter.EntityFilter;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2300;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class EntityFilterManager
extends TranslationContext {
    private static final EntityFilterManager INSTANCE = new EntityFilterManager();
    private static final Predicate<class_1297> DEFAULT_FILTER = entity -> true;
    private final Map<class_1299<?>, Predicate<class_1297>> entityFilter = Maps.newLinkedHashMap();

    public EntityFilterManager() {
        super(LifeTimeTracker.getInstance().getTranslator().getDerivedTranslator("filter"));
    }

    public static EntityFilterManager getInstance() {
        return INSTANCE;
    }

    public Predicate<class_1297> getFilter(@Nullable class_1299<?> entityType) {
        return this.entityFilter.getOrDefault(entityType, DEFAULT_FILTER);
    }

    public boolean test(class_1297 entity) {
        return this.getFilter(null).test(entity) && this.getFilter(entity.method_5864()).test(entity);
    }

    public void setEntityFilter(class_2168 source, @Nullable class_1299<?> entityType, @Nullable class_2300 entitySelector) {
        class_5250 typeName = this.getEntityTypeText(entityType);
        if (entitySelector != null) {
            if (!entitySelector.method_9819() || ((EntitySelectorAccessor)entitySelector).getPlayerName() != null) {
                Messenger.tell(source, this.tr("unsupported.0", new Object[0]));
                Messenger.tell(source, this.tr("unsupported.1", new Object[0]));
            } else {
                EntityFilter entityFilter = new EntityFilter(source, entitySelector);
                this.entityFilter.put(entityType, entityFilter);
                Messenger.tell(source, this.tr("filter_set", typeName, entityFilter.toText()));
            }
        } else {
            this.entityFilter.remove(entityType);
            Messenger.tell(source, this.tr("filter_removed", typeName));
        }
    }

    public class_5250 getEntityFilterText(@Nullable class_1299<?> entityType) {
        Predicate<class_1297> entityPredicate = this.getFilter(entityType);
        return entityPredicate instanceof EntityFilter ? ((EntityFilter)entityPredicate).toText() : this.tr("none", new Object[0]);
    }

    public class_5250 getEntityTypeText(@Nullable class_1299<?> entityType) {
        return entityType != null ? Messenger.entityType(entityType) : this.tr("global", new Object[0]);
    }

    public void displayFilter(class_2168 source, @Nullable class_1299<?> entityType) {
        Messenger.tell(source, this.tr("display", this.getEntityTypeText(entityType), this.getEntityFilterText(entityType)));
    }

    public int displayAllFilters(class_2168 source) {
        Messenger.tell(source, this.tr("display_total", this.entityFilter.size()));
        this.entityFilter.keySet().forEach(entityType -> Messenger.tell(source, Messenger.c("f - ", this.getEntityTypeText((class_1299<?>)entityType), "g : ", this.getEntityFilterText((class_1299<?>)entityType), "w  ", Messenger.fancy(null, Messenger.s((Object)"[\u00d7]", "r"), this.tr("click_to_clear", new Object[0]), Messenger.ClickEvents.runCommand(String.format("/%s filter %s clear", LifeTimeTracker.getInstance().getCommandPrefix(), entityType != null ? LifeTimeTrackerUtil.getEntityTypeDescriptor(entityType) : this.tr("global", new Object[0])))))));
        return 1;
    }
}

