/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.libs.net.fabricmc.mappings.model;

import carpettisaddition.libs.net.fabricmc.mapping.reader.v2.MappingGetter;
import carpettisaddition.libs.net.fabricmc.mapping.reader.v2.TinyMetadata;
import carpettisaddition.libs.net.fabricmc.mapping.reader.v2.TinyV2Factory;
import carpettisaddition.libs.net.fabricmc.mapping.reader.v2.TinyVisitor;
import carpettisaddition.libs.net.fabricmc.mappings.ClassEntry;
import carpettisaddition.libs.net.fabricmc.mappings.EntryTriple;
import carpettisaddition.libs.net.fabricmc.mappings.FieldEntry;
import carpettisaddition.libs.net.fabricmc.mappings.Mappings;
import carpettisaddition.libs.net.fabricmc.mappings.MethodEntry;
import carpettisaddition.libs.net.fabricmc.mappings.model.CommentEntry;
import carpettisaddition.libs.net.fabricmc.mappings.model.Comments;
import carpettisaddition.libs.net.fabricmc.mappings.model.CommentsImpl;
import carpettisaddition.libs.net.fabricmc.mappings.model.LocalVariable;
import carpettisaddition.libs.net.fabricmc.mappings.model.LocalVariableEntry;
import carpettisaddition.libs.net.fabricmc.mappings.model.MethodParameter;
import carpettisaddition.libs.net.fabricmc.mappings.model.MethodParameterEntry;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.ToIntFunction;

@Deprecated
public class V2MappingsProvider {
    public static Mappings readTinyMappings(BufferedReader reader) throws IOException {
        Visitor visitor = new Visitor();
        TinyV2Factory.visit(reader, visitor);
        return visitor.getMappings();
    }

    private static class Visitor
    implements TinyVisitor {
        private Collection<ClassEntry> classEntries = new ArrayList<ClassEntry>();
        private Collection<MethodEntry> methodEntries = new ArrayList<MethodEntry>();
        private Collection<FieldEntry> fieldEntries = new ArrayList<FieldEntry>();
        private Collection<MethodParameterEntry> methodParameterEntries = new ArrayList<MethodParameterEntry>();
        private Collection<LocalVariableEntry> localVariableEntries = new ArrayList<LocalVariableEntry>();
        private Comments comments = new CommentsImpl(new ArrayList<CommentEntry.Class>(), new ArrayList<CommentEntry.Field>(), new ArrayList<CommentEntry.Method>(), new ArrayList<CommentEntry.Parameter>(), new ArrayList<CommentEntry.LocalVariableComment>());
        private List<String> namespaces;
        private ToIntFunction<String> namespaceIndices;
        private int namespaceAmount;
        private String[] currentClassNames;
        private EntryTriple[] currentMemberNames;
        private MethodParameter[] currentParameterNames;
        private LocalVariable[] currentLocalVariableNames;
        private List<String> currentComments;
        private CommentType currentCommentType;

        private Visitor() {
        }

        @Override
        public void start(TinyMetadata metadata) {
            this.namespaces = metadata.getNamespaces();
            this.namespaceAmount = this.namespaces.size();
            this.namespaceIndices = metadata::index;
        }

        @Override
        public void pushClass(MappingGetter name) {
            this.storeClassMappings(name);
            this.classEntries.add(new ClassEntryImpl(this.namespaceIndices, this.currentClassNames));
            this.setNewCommentType(CommentType.CLASS);
        }

        @Override
        public void pushField(MappingGetter name, String descriptor) {
            this.storeMemberMappings(name, descriptor);
            this.fieldEntries.add(new MemberEntryImpl(this.namespaceIndices, this.currentMemberNames));
            this.setNewCommentType(CommentType.FIELD);
        }

        @Override
        public void pushMethod(MappingGetter name, String descriptor) {
            this.storeMemberMappings(name, descriptor);
            this.methodEntries.add(new MemberEntryImpl(this.namespaceIndices, this.currentMemberNames));
            this.setNewCommentType(CommentType.METHOD);
        }

        @Override
        public void pushParameter(MappingGetter name, int localVariableIndex) {
            this.currentParameterNames = new MethodParameter[this.namespaceAmount];
            for (int i = 0; i < this.namespaceAmount; ++i) {
                this.currentParameterNames[i] = new MethodParameter(this.currentMemberNames[i], name.get(i), localVariableIndex);
            }
            this.methodParameterEntries.add(new ParameterEntryImpl(this.namespaceIndices, this.currentParameterNames));
            this.setNewCommentType(CommentType.PARAMETER);
        }

        @Override
        public void pushLocalVariable(MappingGetter name, int localVariableIndex, int localVariableStartOffset, int localVariableTableIndex) {
            this.currentLocalVariableNames = new LocalVariable[this.namespaceAmount];
            for (int i = 0; i < this.namespaceAmount; ++i) {
                this.currentLocalVariableNames[i] = new LocalVariable(this.currentMemberNames[i], name.get(i), localVariableIndex, localVariableStartOffset, localVariableTableIndex);
            }
            this.localVariableEntries.add(new LocalVariableEntryEntryImpl(this.namespaceIndices, this.currentLocalVariableNames));
            this.setNewCommentType(CommentType.LOCAL_VARIABLE);
        }

        @Override
        public void pushComment(String comment) {
            switch (this.currentCommentType) {
                case CLASS: {
                    if (!this.currentComments.isEmpty()) break;
                    this.comments.getClassComments().add(new CommentEntry.Class(this.currentComments, this.currentClassNames[0]));
                    break;
                }
                case FIELD: {
                    if (!this.currentComments.isEmpty()) break;
                    this.comments.getFieldComments().add(new CommentEntry.Field(this.currentComments, this.currentMemberNames[0]));
                    break;
                }
                case METHOD: {
                    if (!this.currentComments.isEmpty()) break;
                    this.comments.getMethodComments().add(new CommentEntry.Method(this.currentComments, this.currentMemberNames[0]));
                    break;
                }
                case PARAMETER: {
                    if (!this.currentComments.isEmpty()) break;
                    this.comments.getMethodParameterComments().add(new CommentEntry.Parameter(this.currentComments, this.currentParameterNames[0]));
                    break;
                }
                case LOCAL_VARIABLE: {
                    if (!this.currentComments.isEmpty()) break;
                    this.comments.getLocalVariableComments().add(new CommentEntry.LocalVariableComment(this.currentComments, this.currentLocalVariableNames[0]));
                    break;
                }
                default: {
                    throw new RuntimeException("unexpected comment without parent");
                }
            }
            this.currentComments.add(comment);
        }

        private void setNewCommentType(CommentType type) {
            this.currentCommentType = type;
            this.currentComments = new ArrayList<String>();
        }

        private void storeClassMappings(MappingGetter namesProvider) {
            this.currentClassNames = new String[this.namespaceAmount];
            for (int i = 0; i < this.namespaceAmount; ++i) {
                this.currentClassNames[i] = namesProvider.get(i);
            }
        }

        private void storeMemberMappings(MappingGetter namesProvider, String descriptor) {
            this.currentMemberNames = new EntryTriple[this.namespaceAmount];
            for (int i = 0; i < this.namespaceAmount; ++i) {
                this.currentMemberNames[i] = new EntryTriple(this.currentClassNames[i], namesProvider.get(i), descriptor);
            }
        }

        public Mappings getMappings() {
            return new MappingsImpl(this.classEntries, this.methodEntries, this.fieldEntries, this.methodParameterEntries, this.localVariableEntries, this.namespaces, this.comments);
        }

        private class MappingsImpl
        implements Mappings {
            private Collection<ClassEntry> classEntries;
            private Collection<MethodEntry> methodEntries;
            private Collection<FieldEntry> fieldEntries;
            private Collection<MethodParameterEntry> methodParameterEntries;
            private Collection<LocalVariableEntry> localVariableEntries;
            private Collection<String> namespaces;
            private Comments comments;

            public MappingsImpl(Collection<ClassEntry> classEntries, Collection<MethodEntry> methodEntries, Collection<FieldEntry> fieldEntries, Collection<MethodParameterEntry> methodParameterEntries, Collection<LocalVariableEntry> localVariableEntries, Collection<String> namespaces, Comments comments) {
                this.classEntries = classEntries;
                this.methodEntries = methodEntries;
                this.fieldEntries = fieldEntries;
                this.methodParameterEntries = methodParameterEntries;
                this.localVariableEntries = localVariableEntries;
                this.namespaces = namespaces;
                this.comments = comments;
            }

            @Override
            public Collection<ClassEntry> getClassEntries() {
                return this.classEntries;
            }

            @Override
            public Collection<MethodEntry> getMethodEntries() {
                return this.methodEntries;
            }

            @Override
            public Collection<FieldEntry> getFieldEntries() {
                return this.fieldEntries;
            }

            @Override
            public Collection<MethodParameterEntry> getMethodParameterEntries() {
                return this.methodParameterEntries;
            }

            @Override
            public Collection<LocalVariableEntry> getLocalVariableEntries() {
                return this.localVariableEntries;
            }

            @Override
            public Collection<String> getNamespaces() {
                return this.namespaces;
            }

            @Override
            public Comments getComments() {
                return this.comments;
            }
        }
    }

    private static class LocalVariableEntryEntryImpl
    implements LocalVariableEntry {
        private final ToIntFunction<String> namespaceIndices;
        private final LocalVariable[] names;

        LocalVariableEntryEntryImpl(ToIntFunction<String> namespaceIndices, LocalVariable[] names) {
            this.namespaceIndices = namespaceIndices;
            this.names = names;
        }

        @Override
        public LocalVariable get(String namespace) {
            return this.names[this.namespaceIndices.applyAsInt(namespace)];
        }
    }

    private static class ParameterEntryImpl
    implements MethodParameterEntry {
        private final ToIntFunction<String> namespaceIndices;
        private final MethodParameter[] names;

        ParameterEntryImpl(ToIntFunction<String> namespaceIndices, MethodParameter[] names) {
            this.namespaceIndices = namespaceIndices;
            this.names = names;
        }

        @Override
        public MethodParameter get(String namespace) {
            return this.names[this.namespaceIndices.applyAsInt(namespace)];
        }
    }

    private static class MemberEntryImpl
    implements FieldEntry,
    MethodEntry {
        private final ToIntFunction<String> namespaceIndices;
        private final EntryTriple[] names;

        MemberEntryImpl(ToIntFunction<String> namespaceIndices, EntryTriple[] names) {
            this.namespaceIndices = namespaceIndices;
            this.names = names;
        }

        @Override
        public EntryTriple get(String namespace) {
            return this.names[this.namespaceIndices.applyAsInt(namespace)];
        }
    }

    private static class ClassEntryImpl
    implements ClassEntry {
        private final ToIntFunction<String> namespaceIndices;
        private final String[] names;

        ClassEntryImpl(ToIntFunction<String> namespaceIndices, String[] names) {
            this.namespaceIndices = namespaceIndices;
            this.names = names;
        }

        @Override
        public String get(String namespace) {
            return this.names[this.namespaceIndices.applyAsInt(namespace)];
        }
    }

    private static enum CommentType {
        CLASS,
        FIELD,
        METHOD,
        PARAMETER,
        LOCAL_VARIABLE;

    }
}

