/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.mobcapsLocal;

import carpet.logging.HUDLogger;
import carpet.utils.SpawnReporter;
import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.logging.TISAdditionLoggerRegistry;
import carpettisaddition.logging.loggers.AbstractHUDLogger;
import carpettisaddition.mixins.logger.mobcapsLocal.SpawnDensityCapperAccessor;
import carpettisaddition.mixins.logger.mobcapsLocal.SpawnDensityCapperDensityCapAccessor;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.compat.DimensionWrapper;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_6540;
import org.jetbrains.annotations.Nullable;

public class MobcapsLocalLogger
extends AbstractHUDLogger {
    public static final String NAME = "mobcapsLocal";
    private static final MobcapsLocalLogger INSTANCE = new MobcapsLocalLogger();
    private final Map<DimensionWrapper, class_6540> capperMap = Maps.newHashMap();
    private final ThreadLocal<@Nullable Object2IntMap<class_1311>> mobcapsMap = ThreadLocal.withInitial(() -> null);

    private MobcapsLocalLogger() {
        super(NAME, true);
    }

    public static MobcapsLocalLogger getInstance() {
        return INSTANCE;
    }

    @Override
    public class_5250[] onHudUpdate(String option, class_1657 playerEntity) {
        if (option != null) {
            class_3222 specifiedPlayer = CarpetTISAdditionServer.minecraft_server.method_3760().method_14566(option);
            if (specifiedPlayer != null) {
                playerEntity = specifiedPlayer;
            } else {
                return new class_5250[]{Messenger.formatting(this.tr("player_not_found", option), class_124.field_1080)};
            }
        }
        if (playerEntity instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)playerEntity;
            class_5250 result = Messenger.c("g [", Messenger.formatting(this.tr("local", new Object[0]), "g"), "g ] ");
            this.withLocalMobcapContext(serverPlayerEntity, () -> {
                List lines = SpawnReporter.printMobcapsForDimension((class_3218)serverPlayerEntity.method_14220(), (boolean)false);
                result.method_10852((class_2561)lines.get(0));
                if (option != null) {
                    result.method_10852((class_2561)Messenger.s((Object)String.format(" (%s)", option), "g"));
                }
            }, () -> result.method_27693("-- Not available --"));
            return new class_5250[]{result};
        }
        return new class_5250[]{Messenger.s("-- Not ServerPlayerEntity --")};
    }

    @Override
    public HUDLogger createCarpetLogger() {
        return new HUDLogger(TISAdditionLoggerRegistry.getLoggerField(NAME), NAME, null, null, false){

            public String[] getOptions() {
                return CarpetTISAdditionServer.minecraft_server.method_3858();
            }
        };
    }

    public void setCapper(DimensionWrapper dim, class_6540 capper) {
        this.capperMap.put(dim, capper);
    }

    public void onServerClosed() {
        this.capperMap.clear();
    }

    @Nullable
    public Object2IntMap<class_1311> getMobcapsMap() {
        return this.mobcapsMap.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withLocalMobcapContext(class_3222 player, Runnable runnable, Runnable failureCallback) {
        class_6540 capper = this.capperMap.get(DimensionWrapper.of((class_1297)player));
        if (capper != null) {
            class_6540.class_6541 cap = ((SpawnDensityCapperAccessor)capper).getPlayersToDensityCap().getOrDefault(player, SpawnDensityCapperDensityCapAccessor.invokeConstructor());
            this.mobcapsMap.set(((SpawnDensityCapperDensityCapAccessor)cap).getSpawnGroupsToDensity());
            try {
                runnable.run();
            }
            finally {
                this.mobcapsMap.set(null);
            }
        } else {
            failureCallback.run();
        }
    }
}

