/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.rule.lightUpdates;

import carpettisaddition.CarpetTISAdditionSettings;
import net.minecraft.class_3227;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3227.class}, priority=1500)
public abstract class ServerLightingProviderMixin {
    private final ThreadLocal<Boolean> enqueueNotImportant = ThreadLocal.withInitial(() -> false);

    @Inject(method={"checkBlock"}, at={@At(value="HEAD")})
    private void thisEnqueueIsNotImportant(CallbackInfo ci) {
        this.enqueueNotImportant.set(true);
    }

    @Inject(method={"enqueue(IILjava/util/function/IntSupplier;Lnet/minecraft/server/world/ServerLightingProvider$Stage;Ljava/lang/Runnable;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onEnqueueingLightUpdateTask(CallbackInfo ci) {
        CarpetTISAdditionSettings.LightUpdateOptions rule = CarpetTISAdditionSettings.lightUpdates;
        if (rule.shouldEnqueueLightTask()) {
            return;
        }
        if (this.enqueueNotImportant.get().booleanValue() || rule == CarpetTISAdditionSettings.LightUpdateOptions.OFF) {
            ci.cancel();
        }
        this.enqueueNotImportant.set(false);
    }

    @Inject(method={"runTasks"}, at={@At(value="HEAD")})
    private void onExecutingLightUpdates(CallbackInfo ci) {
        while (!CarpetTISAdditionSettings.lightUpdates.shouldExecuteLightTask()) {
            Thread.yield();
        }
    }
}

