/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.rule.optimizedFastEntityMovement.compat.lithium;

import carpettisaddition.helpers.rule.optimizedFastEntityMovement.OFEMContext;
import carpettisaddition.helpers.rule.optimizedFastEntityMovement.OFEMUtil;
import carpettisaddition.utils.mixin.testers.LithiumEntityMovementOptimizationTester;
import com.google.common.collect.Lists;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.List;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import me.jellysquid.mods.lithium.common.entity.LithiumEntityCollisions;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Restriction(require={@Condition(value="minecraft", versionPredicates={">=1.18"}), @Condition(type=Condition.Type.TESTER, tester=LithiumEntityMovementOptimizationTester.class)})
@Mixin(value={class_1297.class}, priority=2000)
public abstract class EntityMixin {
    @Unique
    private static final List<class_265> EMPTY_BLOCK_COLLECTIONS = Lists.newArrayList();

    @WrapOperation(method={"lithiumCollideMultiAxisMovement"}, at={@At(value="INVOKE", target="Lme/jellysquid/mods/lithium/common/entity/LithiumEntityCollisions;getBlockCollisions(Lnet/minecraft/world/World;Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/Box;)Ljava/util/List;", remap=true)}, remap=false)
    @Dynamic(value="Should be added by lithium entity.collisions.movement")
    private static List<class_265> dontUseThatLargeBlockCollisions(class_1937 world, class_1297 entity, class_238 box, Operation<List<class_265>> original, @Nullable class_1297 entityParam, class_243 movement, class_238 entityBoundingBox, class_1937 worldParam, @Share(value="OFEMContext") LocalRef<OFEMContext> context) {
        OFEMContext ctx = OFEMUtil.checkAndCreateContext(world, entity, movement);
        context.set((Object)ctx);
        if (ctx != null) {
            return EMPTY_BLOCK_COLLECTIONS;
        }
        return (List)original.call(new Object[]{world, entity, box});
    }

    @ModifyArgs(method={"lithiumCollideMultiAxisMovement"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/shape/VoxelShapes;calculateMaxOffset(Lnet/minecraft/util/math/Direction$Axis;Lnet/minecraft/util/math/Box;Ljava/lang/Iterable;D)D", remap=true), remap=false)
    @Dynamic(value="Should be added by lithium entity.collisions.movement")
    private static void useAxisOnlyBlockCollisions(Args args, @Share(value="OFEMContext") LocalRef<OFEMContext> context) {
        OFEMContext ctx = (OFEMContext)context.get();
        if (ctx == null) {
            return;
        }
        class_2350.class_2351 axis = (class_2350.class_2351)args.get(0);
        class_238 entityBoundingBox = (class_238)args.get(1);
        Iterable blockCollisions = (Iterable)args.get(2);
        double maxDist = (Double)args.get(3);
        ctx.axis = axis;
        ctx.movementOnAxis = maxDist;
        ctx.entityBoundingBox = entityBoundingBox;
        if (blockCollisions == EMPTY_BLOCK_COLLECTIONS) {
            args.set(2, OFEMUtil.getAxisOnlyBlockCollision(ctx, LithiumEntityCollisions::getBlockCollisions));
        }
    }
}

