/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpettisaddition.CarpetTISAdditionMod;
import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.commands.AbstractCommand;
import carpettisaddition.commands.CommandTreeContext;
import carpettisaddition.commands.lifetime.LifeTimeCommand;
import carpettisaddition.commands.lifetime.LifeTimeTracker;
import carpettisaddition.commands.manipulate.ManipulateCommand;
import carpettisaddition.commands.raid.RaidCommand;
import carpettisaddition.commands.raid.RaidTracker;
import carpettisaddition.commands.raycast.RaycastCommand;
import carpettisaddition.commands.refresh.RefreshCommand;
import carpettisaddition.commands.removeentity.RemoveEntityCommand;
import carpettisaddition.commands.scounter.SupplierCounterCommand;
import carpettisaddition.commands.sleep.SleepCommand;
import carpettisaddition.commands.speedtest.SpeedTestCommand;
import carpettisaddition.commands.stop.StopCommandDoubleConfirmation;
import carpettisaddition.commands.xcounter.XpCounterCommand;
import carpettisaddition.helpers.rule.instantBlockUpdaterReintroduced.InstantBlockUpdaterChanger;
import carpettisaddition.helpers.rule.lightEngineMaxBatchSize.LightBatchSizeChanger;
import carpettisaddition.helpers.rule.yeetUpdateSuppressionCrash.UpdateSuppressionYeeter;
import carpettisaddition.logging.TISAdditionLoggerRegistry;
import carpettisaddition.logging.loggers.lightqueue.LightQueueHUDLogger;
import carpettisaddition.logging.loggers.microtiming.MicroTimingLoggerManager;
import carpettisaddition.logging.loggers.microtiming.marker.MicroTimingMarkerManager;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingStandardCarpetLogger;
import carpettisaddition.logging.loggers.mobcapsLocal.MobcapsLocalLogger;
import carpettisaddition.logging.loggers.phantom.PhantomLogger;
import carpettisaddition.network.TISCMServerPacketHandler;
import carpettisaddition.settings.CarpetRuleRegistrar;
import carpettisaddition.translations.TISAdditionTranslations;
import carpettisaddition.utils.deobfuscator.StackTraceDeobfuscator;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;

public class CarpetTISAdditionServer
implements CarpetExtension {
    private static final CarpetTISAdditionServer INSTANCE = new CarpetTISAdditionServer();
    public static final String compactName = CarpetTISAdditionMod.COMPACT_NAME;
    public static final Logger LOGGER = CarpetTISAdditionMod.LOGGER;
    public static MinecraftServer minecraft_server;

    public String version() {
        return "carpet-tis-addition";
    }

    public static CarpetTISAdditionServer getInstance() {
        return INSTANCE;
    }

    public static void init() {
        CarpetServer.manageExtension((CarpetExtension)INSTANCE);
        StackTraceDeobfuscator.fetchMapping();
        TISAdditionTranslations.loadTranslations();
        UpdateSuppressionYeeter.noop();
        StopCommandDoubleConfirmation.noop();
    }

    public void onGameStarted() {
        CarpetRuleRegistrar.register(CarpetServer.settingsManager, CarpetTISAdditionSettings.class);
        TISAdditionLoggerRegistry.registerLoggers();
    }

    public void onServerLoaded(MinecraftServer server) {
        minecraft_server = server;
        CarpetTISAdditionSettings.onWorldLoadingStarted();
    }

    public void onServerLoadedWorlds$TISCM(MinecraftServer server) {
        MicroTimingLoggerManager.attachServer(server);
        MicroTimingMarkerManager.getInstance().clear();
        InstantBlockUpdaterChanger.apply();
        LifeTimeTracker.attachServer(server);
        LightBatchSizeChanger.apply();
        LightQueueHUDLogger.getInstance().attachServer(server);
    }

    public void onServerClosed(MinecraftServer server) {
        LifeTimeTracker.detachServer();
        MicroTimingLoggerManager.detachServer();
        RaidTracker.getInstance().stop();
        SpeedTestCommand.getInstance().onServerClosed();
        MobcapsLocalLogger.getInstance().onServerClosed();
    }

    public void onTick(MinecraftServer server) {
        LightQueueHUDLogger.getInstance().tick();
        MicroTimingMarkerManager.getInstance().tick();
        PhantomLogger.getInstance().tick();
    }

    public void onCarpetClientHello(class_3222 player) {
        MicroTimingStandardCarpetLogger.getInstance().onCarpetClientHello(player);
    }

    public void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        CommandTreeContext.Register context = CommandTreeContext.of(dispatcher);
        Lists.newArrayList((Object[])new AbstractCommand[]{LifeTimeCommand.getInstance(), ManipulateCommand.getInstance(), RefreshCommand.getInstance(), RaidCommand.getInstance(), RaycastCommand.getInstance(), RemoveEntityCommand.getInstance(), SleepCommand.getInstance(), SpeedTestCommand.getInstance(), SupplierCounterCommand.getInstance(), XpCounterCommand.getInstance()}).forEach(command -> command.registerCommand(context));
    }

    public void onPlayerLoggedOut(class_3222 player) {
        TISCMServerPacketHandler.getInstance().onPlayerDisconnected(player.field_13987);
        SpeedTestCommand.getInstance().onPlayerDisconnected(player);
    }
}

