/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands;

import carpettisaddition.translations.TranslationContext;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.CounterUtils;
import carpettisaddition.utils.GameUtils;
import carpettisaddition.utils.Messenger;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2554;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTracker
extends TranslationContext {
    private static final Translator baseTranslator = new Translator("tracker");
    private final String name;
    private boolean tracking;
    private long startTick;
    private long startMillis;
    protected static final int START_TRACKING_NO_OP = 0;
    protected static final int START_TRACKING_OK = 1;
    protected static final int STOP_TRACKING_NO_OP = 0;
    protected static final int STOP_TRACKING_OK = 1;

    public AbstractTracker(String name) {
        super("tracker." + name.toLowerCase());
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getCommandPrefix() {
        return this.name.toLowerCase();
    }

    public class_2554 getTranslatedName() {
        return this.tr("name", new Object[0]);
    }

    public class_2554 getTranslatedNameFull() {
        return baseTranslator.tr("tracker_name_full", this.getTranslatedName());
    }

    public boolean isTracking() {
        return this.tracking;
    }

    public long getStartMillis() {
        return this.startMillis;
    }

    public long getStartTick() {
        return this.startTick;
    }

    public int startTracking(@NotNull class_2168 source, boolean isRestart, boolean showFeedback) {
        if (this.isTracking()) {
            if (showFeedback) {
                Messenger.tell(source, Messenger.formatting(baseTranslator.tr("tracking_already_started", this.getTranslatedNameFull()), class_124.field_1061));
            }
            return 0;
        }
        this.tracking = true;
        this.startTick = GameUtils.getGameTime();
        this.startMillis = System.currentTimeMillis();
        if (showFeedback) {
            Messenger.tell(source, baseTranslator.tr("tracking_started", this.getTranslatedNameFull()), true);
        }
        this.initTracker();
        return 1;
    }

    public int stopTracking(@Nullable class_2168 source, boolean isRestart, boolean showFeedback) {
        boolean wasTracking = this.isTracking();
        if (source != null) {
            if (wasTracking) {
                this.reportTracking(source, false);
                if (showFeedback) {
                    Messenger.tell(source, Messenger.s(" "));
                    Messenger.tell(source, baseTranslator.tr("tracking_stopped", this.getTranslatedNameFull()), true);
                }
            } else if (showFeedback) {
                Messenger.tell(source, Messenger.s(" "));
                Messenger.tell(source, Messenger.formatting(baseTranslator.tr("tracking_not_started", this.getTranslatedNameFull()), class_124.field_1061));
            }
        }
        this.tracking = false;
        return wasTracking ? 1 : 0;
    }

    public int restartTracking(class_2168 source) {
        boolean wasTracking = this.isTracking();
        this.stopTracking(source, true, false);
        this.startTracking(source, true, false);
        if (wasTracking) {
            Messenger.tell(source, Messenger.s(" "));
        }
        Messenger.tell(source, baseTranslator.tr("tracking_restarted", this.getTranslatedNameFull()), true);
        return 1;
    }

    protected int doWhenTracking(class_2168 source, Runnable runnable) {
        if (this.isTracking()) {
            runnable.run();
        } else {
            Messenger.tell(source, Messenger.formatting(baseTranslator.tr("tracking_not_started", this.getTranslatedNameFull()), class_124.field_1061));
        }
        return 1;
    }

    public int reportTracking(class_2168 source, boolean realtime) {
        return this.doWhenTracking(source, () -> this.printTrackingResult(source, realtime));
    }

    public LiteralArgumentBuilder<class_2168> getTrackingArgumentBuilder() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tracking").executes(c -> this.reportTracking((class_2168)c.getSource(), false))).then(class_2170.method_9247((String)"start").executes(c -> this.startTracking((class_2168)c.getSource(), false, true)))).then(class_2170.method_9247((String)"stop").executes(c -> this.stopTracking((class_2168)c.getSource(), false, true)))).then(class_2170.method_9247((String)"restart").executes(c -> this.restartTracking((class_2168)c.getSource())))).then(class_2170.method_9247((String)"realtime").executes(c -> this.reportTracking((class_2168)c.getSource(), true)));
    }

    protected long getTrackedTick(boolean realtime) {
        return CounterUtils.getTimeElapsed(this.getStartTick(), this.getStartMillis(), realtime);
    }

    protected long sendTrackedTime(class_2168 source, boolean realtime) {
        long ticks = this.getTrackedTick(realtime);
        Messenger.tell(source, Messenger.c("w  \n", "g ----------- ", this.getTranslatedNameFull(), "g  -----------\n", baseTranslator.tr("tracked", Messenger.c(String.format("w %.2f min (", (double)ticks / 1200.0), baseTranslator.tr(realtime ? "real_time" : "in_game", new Object[0]), "w )"))));
        return ticks;
    }

    public void stop() {
        this.stopTracking(null, false, false);
    }

    protected abstract void initTracker();

    protected abstract void printTrackingResult(class_2168 var1, boolean var2);
}

