/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.lifetime.trackeddata;

import carpettisaddition.commands.lifetime.LifeTimeTracker;
import carpettisaddition.commands.lifetime.removal.RemovalReason;
import carpettisaddition.commands.lifetime.spawning.SpawningReason;
import carpettisaddition.commands.lifetime.utils.AbstractReason;
import carpettisaddition.commands.lifetime.utils.LifeTimeStatistic;
import carpettisaddition.commands.lifetime.utils.LifetimeTexts;
import carpettisaddition.commands.lifetime.utils.SpawningStatistic;
import carpettisaddition.translations.TranslationContext;
import carpettisaddition.utils.CounterUtils;
import carpettisaddition.utils.Messenger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_2554;

public class BasicTrackedData
extends TranslationContext {
    public final Map<SpawningReason, SpawningStatistic> spawningReasons = Maps.newHashMap();
    public final Map<RemovalReason, LifeTimeStatistic> removalReasons = Maps.newHashMap();
    public final LifeTimeStatistic lifeTimeStatistic = new LifeTimeStatistic();

    public BasicTrackedData() {
        super(LifeTimeTracker.getInstance().getTranslator());
    }

    public void updateSpawning(class_1297 entity, SpawningReason reason) {
        this.spawningReasons.computeIfAbsent(reason, k -> new SpawningStatistic()).update(entity);
    }

    public void updateRemoval(class_1297 entity, RemovalReason reason) {
        this.lifeTimeStatistic.update(entity);
        this.removalReasons.computeIfAbsent(reason, r -> new LifeTimeStatistic()).update(entity);
    }

    protected static long getLongMapSum(Map<?, Long> longMap) {
        return longMap.values().stream().mapToLong(v -> v).sum();
    }

    public boolean hasSpawning() {
        return !this.spawningReasons.isEmpty();
    }

    public boolean hasRemoval() {
        return !this.removalReasons.isEmpty();
    }

    public long getSpawningCount() {
        return this.spawningReasons.values().stream().mapToLong(v -> v.count).sum();
    }

    public long getRemovalCount() {
        return this.removalReasons.values().stream().mapToLong(stat -> stat.count).sum();
    }

    public class_2554 getSpawningCountText(long ticks) {
        return Messenger.c(Messenger.formatting(this.tr("spawn_count", new Object[0]), "q"), "g : ", CounterUtils.ratePerHourText(this.getSpawningCount(), ticks, "wgg"));
    }

    public class_2554 getRemovalCountText(long ticks) {
        return Messenger.c(Messenger.formatting(this.tr("removal_count", new Object[0]), "q "), "g : ", CounterUtils.ratePerHourText(this.getRemovalCount(), ticks, "wgg"));
    }

    private static class_2554 getReasonWithRate(AbstractReason reason, long ticks, long count, long total, String indent) {
        double percentage = 100.0 * (double)count / (double)total;
        return Messenger.c(Messenger.s((Object)indent, "g"), reason.toText(), "g : ", CounterUtils.ratePerHourText(count, ticks, "wgg"), "w  ", Messenger.hover(Messenger.s(String.format("%.1f%%", percentage)), Messenger.s(String.format("%.6f%%", percentage))));
    }

    protected class_2554 getSpawningReasonWithRate(SpawningReason reason, long ticks, long count, long total, String indent) {
        return BasicTrackedData.getReasonWithRate(reason, ticks, count, total, indent);
    }

    protected class_2554 getRemovalReasonWithRate(RemovalReason reason, long ticks, long count, long total, String indent) {
        return BasicTrackedData.getReasonWithRate(reason, ticks, count, total, indent);
    }

    public List<class_2554> getSpawningReasonsLines(long ticks, boolean showButton) {
        ArrayList result = Lists.newArrayList();
        long total = this.getSpawningCount();
        this.spawningReasons.entrySet().stream().sorted(Collections.reverseOrder(Comparator.comparingLong(e -> ((SpawningStatistic)e.getValue()).count))).forEach(entry -> {
            SpawningReason reason = (SpawningReason)entry.getKey();
            SpawningStatistic statistic = (SpawningStatistic)entry.getValue();
            if (!statistic.isValid()) {
                return;
            }
            class_2554 line = this.getSpawningReasonWithRate(reason, ticks, statistic.count, total, "  ");
            if (showButton) {
                line = Messenger.join(Messenger.s(" "), line, LifetimeTexts.spawningPosButton(statistic.spawningPosSample, statistic.dimensionSample, "spawning_position_mr"));
            }
            result.add(line);
        });
        return result;
    }

    public List<class_2554> getRemovalReasonsLines(long ticks, boolean showButton) {
        ArrayList result = Lists.newArrayList();
        this.removalReasons.entrySet().stream().sorted(Collections.reverseOrder(Comparator.comparingLong(a -> ((LifeTimeStatistic)a.getValue()).count))).forEach(entry -> {
            RemovalReason reason = (RemovalReason)entry.getKey();
            LifeTimeStatistic statistic = (LifeTimeStatistic)entry.getValue();
            result.add(this.getRemovalReasonWithRate(reason, ticks, statistic.count, this.lifeTimeStatistic.count, "  "));
            result.addAll(statistic.getResult("    ", showButton));
        });
        return result;
    }
}

