/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.helpers.rule.largeBarrel;

import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.helpers.rule.largeBarrel.LargeBarrelHelper;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2753;
import net.minecraft.class_2769;

public class DoubleBlockProperties {
    private static <S extends class_2586> S getBlockEntity(class_2591<S> blockEntityType, class_1922 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (CarpetTISAdditionSettings.largeBarrel && LargeBarrelHelper.enabledOffThreadBlockEntityAccess.get().booleanValue() && world instanceof class_1937) {
            blockEntity = ((class_1937)world).method_16955(pos).method_8321(pos);
        }
        return (S)(blockEntity != null && blockEntity.method_11017() == blockEntityType ? blockEntity : null);
    }

    public static <S extends class_2586> PropertySource<S> toPropertySource(class_2591<S> blockEntityType, Function<class_2680, Type> typeMapper, Function<class_2680, class_2350> function, class_2753 directionProperty, class_2680 state, class_1936 world, class_2338 pos, BiPredicate<class_1936, class_2338> fallbackTester) {
        Type type2;
        boolean bl2;
        S blockEntity = DoubleBlockProperties.getBlockEntity(blockEntityType, (class_1922)world, pos);
        if (blockEntity == null) {
            return PropertyRetriever::getFallback;
        }
        if (fallbackTester.test(world, pos)) {
            return PropertyRetriever::getFallback;
        }
        Type type = typeMapper.apply(state);
        boolean bl = type == Type.SINGLE;
        boolean bl3 = bl2 = type == Type.FIRST;
        if (bl) {
            return new PropertySource.Single<S>(blockEntity);
        }
        class_2338 blockPos = pos.method_10093(function.apply(state));
        class_2680 blockState = world.method_8320(blockPos);
        if (blockState.method_11614() == state.method_11614() && (type2 = typeMapper.apply(blockState)) != Type.SINGLE && type != type2 && blockState.method_11654((class_2769)directionProperty) == state.method_11654((class_2769)directionProperty)) {
            if (fallbackTester.test(world, blockPos)) {
                return PropertyRetriever::getFallback;
            }
            S blockEntity2 = DoubleBlockProperties.getBlockEntity(blockEntityType, (class_1922)world, blockPos);
            if (blockEntity2 != null) {
                S blockEntity3 = bl2 ? blockEntity : blockEntity2;
                S blockEntity4 = bl2 ? blockEntity2 : blockEntity;
                return new PropertySource.Pair<S>(blockEntity3, blockEntity4);
            }
        }
        return new PropertySource.Single<S>(blockEntity);
    }

    public static interface PropertySource<S> {
        public <T> T apply(PropertyRetriever<? super S, T> var1);

        public static final class Single<S>
        implements PropertySource<S> {
            private final S single;

            public Single(S single) {
                this.single = single;
            }

            @Override
            public <T> T apply(PropertyRetriever<? super S, T> propertyRetriever) {
                return propertyRetriever.getFrom(this.single);
            }
        }

        public static final class Pair<S>
        implements PropertySource<S> {
            private final S first;
            private final S second;

            public Pair(S first, S second) {
                this.first = first;
                this.second = second;
            }

            @Override
            public <T> T apply(PropertyRetriever<? super S, T> propertyRetriever) {
                return propertyRetriever.getFromBoth(this.first, this.second);
            }
        }
    }

    public static enum Type {
        SINGLE,
        FIRST,
        SECOND;

    }

    public static interface PropertyRetriever<S, T> {
        public T getFromBoth(S var1, S var2);

        public T getFrom(S var1);

        public T getFallback();
    }
}

