/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.helpers.rule.synchronizedLightThread;

import carpet.utils.CarpetProfiler;
import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.mixins.rule.synchronizedLightThread.ServerLightingProviderAccessor;
import carpettisaddition.mixins.rule.synchronizedLightThread.TaskExecutorAccessor;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.Messenger;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2554;
import net.minecraft.class_3218;
import net.minecraft.class_3227;
import net.minecraft.class_3695;
import net.minecraft.class_3846;
import net.minecraft.class_3847;

public class LightThreadSynchronizer {
    private static final Translator translator = new Translator("rule.synchronizedLightThread");
    public static final String SECTION_NAME = "Lighting synchronization";
    public static final String SECTION_DESCRIPTION = "Light engine synchronization by rule synchronizedLightThread to make sure the lighting engine will not fall behind";

    private static boolean isSafeToWait(boolean synchronizedLightThread, CarpetTISAdditionSettings.LightUpdateOptions lightUpdates) {
        return !synchronizedLightThread || lightUpdates.shouldExecuteLightTask();
    }

    public static void waitForLightThread(class_3218 serverWorld) {
        class_3695 profiler = serverWorld.method_16107();
        profiler.method_15396(SECTION_NAME);
        CarpetProfiler.ProfilerToken token = CarpetProfiler.start_section((class_1937)serverWorld, (String)SECTION_NAME, (CarpetProfiler.TYPE)CarpetProfiler.TYPE.GENERAL);
        class_3227 lightingProvider = serverWorld.method_14178().method_17293();
        if (lightingProvider != null) {
            class_3846<Runnable> processor = ((ServerLightingProviderAccessor)lightingProvider).getProcessor();
            class_3847 queue = ((TaskExecutorAccessor)processor).getQueue();
            while (!queue.method_16911()) {
                Thread.yield();
                if (LightThreadSynchronizer.isSafeToWait(CarpetTISAdditionSettings.synchronizedLightThread, CarpetTISAdditionSettings.lightUpdates)) continue;
            }
        }
        profiler.method_15407();
        CarpetProfiler.end_current_section((CarpetProfiler.ProfilerToken)token);
    }

    public static boolean checkRuleSafety(class_2168 source, boolean synchronizedLightThread, CarpetTISAdditionSettings.LightUpdateOptions lightUpdates) {
        if (LightThreadSynchronizer.isSafeToWait(synchronizedLightThread, lightUpdates)) {
            return true;
        }
        if (source != null) {
            ArrayList list = Lists.newArrayList();
            list.add(Messenger.formatting(translator.tr("safety_warning.0", new Object[0]), "r"));
            list.add(Messenger.formatting(translator.tr("safety_warning.1", new Object[0]), "r"));
            list.add(Messenger.formatting(translator.tr("safety_warning.2", new Object[0]), "r"));
            list.add(Messenger.s((Object)("  - synchronizedLightThread: " + synchronizedLightThread), "r"));
            list.add(Messenger.s((Object)("  - lightUpdates: " + lightUpdates.toString().toLowerCase()), "r"));
            Messenger.tell(source, (Iterable<class_2554>)list);
        }
        return false;
    }
}

