/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.commandblock;

import carpettisaddition.logging.TISAdditionLoggerRegistry;
import carpettisaddition.logging.loggers.AbstractLogger;
import carpettisaddition.logging.loggers.commandblock.ICommandBlockExecutor;
import carpettisaddition.utils.EntityUtils;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.compat.DimensionWrapper;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1697;
import net.minecraft.class_1918;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2554;
import net.minecraft.class_2680;
import net.minecraft.class_3544;

public class CommandBlockLogger
extends AbstractLogger {
    public static final String NAME = "commandBlock";
    public static final int MINIMUM_LOG_INTERVAL = 60;
    public static final int MAXIMUM_PREVIEW_LENGTH = 16;
    private static final CommandBlockLogger INSTANCE = new CommandBlockLogger();

    public CommandBlockLogger() {
        super(NAME, true);
    }

    public static CommandBlockLogger getInstance() {
        return INSTANCE;
    }

    @Override
    public String[] getSuggestedLoggingOption() {
        return new String[]{"throttled", "all"};
    }

    private void logCommandBlockExecution(class_1937 world, class_2554 nameText, class_2554 posText, class_1918 executor, String removeCommand) {
        if (!TISAdditionLoggerRegistry.__commandBlock) {
            return;
        }
        ICommandBlockExecutor iExecutor = (ICommandBlockExecutor)executor;
        long time = world.method_8510();
        String commandPreview = executor.method_8289();
        if (commandPreview.length() > 16) {
            commandPreview = commandPreview.substring(0, 13) + "...";
        }
        String finalCommandPreview = commandPreview;
        this.log(option -> {
            boolean isThrottledLogging;
            boolean bl = isThrottledLogging = !option.equals("all");
            if (time - iExecutor.getLastLoggedTime() < 60L && isThrottledLogging) {
                return null;
            }
            if (isThrottledLogging) {
                iExecutor.setLastLoggedTime(time);
            }
            return new class_2554[]{Messenger.c(this.tr("executed", Messenger.formatting(Messenger.copy(nameText), class_124.field_1065), Messenger.fancy("c", Messenger.s(finalCommandPreview), Messenger.s(executor.method_8289()), Messenger.ClickEvents.suggestCommand(executor.method_8289()))), "g  @ ", posText, "w  ", Messenger.fancy("r", Messenger.s("[\u00d7]"), this.tr("remove_executor", nameText), Messenger.ClickEvents.suggestCommand(removeCommand)))};
        });
    }

    public void onCommandBlockActivated(class_1937 world, class_2338 pos, class_2680 state, class_1918 executor) {
        this.logCommandBlockExecution(world, Messenger.block(state.method_11614()), Messenger.coord("w", (class_2382)pos, DimensionWrapper.of(world)), executor, String.format("/execute in %s run setblock %d %d %d %s", DimensionWrapper.of(world).getIdentifier(), pos.method_10263(), pos.method_10264(), pos.method_10260(), class_2378.field_11146.method_10221((Object)class_2246.field_10124)));
    }

    public void onCommandBlockMinecartActivated(class_1697 entity) {
        if (class_3544.method_15438((String)entity.method_7567().method_8289())) {
            return;
        }
        this.logCommandBlockExecution(EntityUtils.getEntityWorld((class_1297)entity), Messenger.entity(null, (class_1297)entity), Messenger.coord("w", entity.method_19538(), DimensionWrapper.of((class_1297)entity)), entity.method_7567(), String.format("/kill %s", entity.method_5845()));
    }
}

