/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming.marker;

import carpet.script.value.NumericValue;
import carpet.script.value.Value;
import carpettisaddition.helpers.carpet.shape.ShapeHolder;
import carpettisaddition.helpers.carpet.shape.ShapeUtil;
import carpettisaddition.logging.loggers.microtiming.marker.MicroTimingMarkerType;
import carpettisaddition.logging.loggers.microtiming.marker.StorageKey;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingUtil;
import carpettisaddition.mixins.logger.microtiming.marker.DyeColorAccessor;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.TextUtils;
import carpettisaddition.utils.compat.DimensionWrapper;
import carpettisaddition.utils.compat.carpet.scarpet.ShapeDispatcher;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2554;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class MicroTimingMarker {
    public static final int MARKER_SYNC_INTERVAL = 100;
    public static final int MARKER_RENDER_DURATION = 12000;
    private final class_3218 serverWorld;
    private final class_2338 blockPos;
    public final class_1767 color;
    private final ShapeHolder<ShapeDispatcher.Box> box;
    @Nullable
    private final ShapeHolder<ShapeDispatcher.Text> text;
    @Nullable
    private final class_2554 markerName;
    private MicroTimingMarkerType markerType;
    private boolean movable;
    public long tickCounter;

    private MicroTimingMarker(class_3218 serverWorld, class_2338 blockPos, class_1767 color, @Nullable class_2554 markerName, MicroTimingMarkerType markerType, boolean movable) {
        this.serverWorld = serverWorld;
        this.blockPos = blockPos;
        this.color = color;
        this.markerName = markerName;
        this.markerType = markerType;
        this.movable = movable;
        Function<class_2338, class_243> fv = class_243::new;
        this.box = ShapeUtil.createBox(fv.apply(blockPos), fv.apply(blockPos.method_10069(1, 1, 1)), DimensionWrapper.of((class_1937)serverWorld), (long)((DyeColorAccessor)this.color).getTextColor() << 8 | 0xAFL);
        if (this.markerName != null) {
            class_2554 text = Messenger.c(Messenger.s(Messenger.parseCarpetStyle(MicroTimingUtil.getColorStyle(this.color)).method_10973() + "# " + class_124.field_1070), Messenger.copy(this.markerName));
            this.text = ShapeUtil.createLabel((class_2561)text, new class_243((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5), DimensionWrapper.of((class_1937)serverWorld), null);
        } else {
            this.text = null;
        }
        this.updateLineWidth();
    }

    public MicroTimingMarker(class_3218 serverWorld, class_2338 blockPos, class_1767 color, @Nullable class_2554 markerName) {
        this(serverWorld, blockPos, color, markerName, MicroTimingMarkerType.REGULAR, false);
    }

    public boolean isMovable() {
        return this.movable;
    }

    public void setMovable(boolean movable) {
        this.movable = movable;
    }

    @Nullable
    public String getMarkerNameString() {
        return this.markerName != null ? this.markerName.getString() : null;
    }

    public MicroTimingMarkerType getMarkerType() {
        return this.markerType;
    }

    private void updateLineWidth() {
        this.box.setValue("line", (Value)new NumericValue((double)this.markerType.getLineWidth()));
    }

    public boolean rollMarkerType() {
        boolean hasNext;
        switch (this.markerType) {
            case REGULAR: {
                this.markerType = MicroTimingMarkerType.END_ROD;
                hasNext = true;
                break;
            }
            default: {
                hasNext = false;
            }
        }
        if (hasNext) {
            this.cleanShapeToAll();
            this.updateLineWidth();
            this.sendShapeToAll();
        }
        return hasNext;
    }

    public List<Pair<ShapeDispatcher.ExpiringShape, Map<String, Value>>> getShapeDataList(boolean display) {
        ArrayList result = Lists.newArrayList();
        result.add(this.box.toPair(display));
        if (this.text != null) {
            result.add(this.text.toPair(display));
        }
        return result;
    }

    public void sendShapeToAll() {
        ShapeDispatcher.sendShape(MicroTimingUtil.getSubscribedPlayers(), this.getShapeDataList(true));
    }

    public void cleanShapeToAll() {
        ShapeDispatcher.sendShape(MicroTimingUtil.getSubscribedPlayers(), this.getShapeDataList(false));
    }

    public StorageKey getStorageKey() {
        return new StorageKey((class_1937)this.serverWorld, this.blockPos);
    }

    public MicroTimingMarker offsetCopy(class_2350 direction) {
        return new MicroTimingMarker(this.serverWorld, this.blockPos.method_10093(direction), this.color, this.markerName, this.markerType, this.movable);
    }

    private class_2554 withFormattingSymbol(String text) {
        return Messenger.s(Messenger.parseCarpetStyle(MicroTimingUtil.getColorStyle(this.color)).method_10973() + text + class_124.field_1070);
    }

    public class_2554 toShortText() {
        return this.withFormattingSymbol(TextUtils.coord((class_2382)this.blockPos));
    }

    public class_2554 toFullText() {
        return Messenger.c(Messenger.s(TextUtils.coord((class_2382)this.blockPos)), this.withFormattingSymbol(" " + this.color.toString()));
    }
}

