/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.helpers.rule.fakePlayerTicksLikeRealPlayer;

import carpet.helpers.EntityPlayerActionPack;
import carpettisaddition.CarpetTISAdditionMod;
import carpettisaddition.utils.PlayerUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class FakePlayerTicker {
    private static final FakePlayerTicker INSTANCE = new FakePlayerTicker();
    private final Queue<ActionPackTickTask> pendingActionPackTasks = Queues.newConcurrentLinkedQueue();
    private final List<class_3222> pendingPlayersToBeEntityTicked = Lists.newArrayList();

    public static FakePlayerTicker getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayerEntityTick(class_3222 player) {
        List<class_3222> list = this.pendingPlayersToBeEntityTicked;
        synchronized (list) {
            this.pendingPlayersToBeEntityTicked.add(player);
        }
    }

    public void addActionPackTick(class_3222 player, EntityPlayerActionPack actionPack) {
        MinecraftServer server = PlayerUtils.getServerFromPlayer(player);
        if (server != null) {
            Runnable runnable = FakePlayerTicker.transformActionPackTickTask(() -> ((EntityPlayerActionPack)actionPack).onUpdate());
            ActionPackTickTask task = new ActionPackTickTask(player, runnable);
            this.pendingActionPackTasks.add(task);
        }
    }

    private static Runnable transformActionPackTickTask(Runnable task) {
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void networkPhaseTick() {
        ArrayList players = Lists.newArrayList();
        List<class_3222> list = this.pendingPlayersToBeEntityTicked;
        synchronized (list) {
            players.addAll(this.pendingPlayersToBeEntityTicked);
            this.pendingPlayersToBeEntityTicked.clear();
        }
        for (class_3222 player : players) {
            try {
                player.method_14226();
            }
            catch (Exception e) {
                CarpetTISAdditionMod.LOGGER.warn("Failed to perform entity tick for carpet fake player {}", (Object)player.method_5477(), (Object)e);
            }
        }
    }

    public void asyncTaskPhaseTick() {
        ActionPackTickTask task;
        while ((task = this.pendingActionPackTasks.poll()) != null) {
            class_3222 player = task.player;
            Runnable runnable = task.runnable;
            try {
                runnable.run();
            }
            catch (Exception e) {
                CarpetTISAdditionMod.LOGGER.error("Failed to perform player action pack tick for player {}", (Object)player.method_5477(), (Object)e);
            }
        }
    }

    private static class ActionPackTickTask {
        public final class_3222 player;
        public final Runnable runnable;

        public ActionPackTickTask(class_3222 player, Runnable runnable) {
            this.player = player;
            this.runnable = runnable;
        }
    }
}

