/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.entity;

import carpet.logging.LoggerRegistry;
import carpettisaddition.logging.loggers.AbstractLogger;
import carpettisaddition.utils.EntityUtils;
import carpettisaddition.utils.Messenger;
import carpettisaddition.utils.WorldUtils;
import carpettisaddition.utils.compat.DimensionWrapper;
import carpettisaddition.utils.deobfuscator.StackTracePrinter;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public abstract class EntityLogger<T extends class_1297>
extends AbstractLogger {
    private static final EntityLogger<class_1297> translator = new EntityLogger<class_1297>("entity"){

        @Override
        protected boolean getAcceleratorBoolean() {
            throw new RuntimeException();
        }
    };

    public EntityLogger(String loggerName) {
        super(loggerName, false);
    }

    @Override
    public String getDefaultLoggingOption() {
        return LoggingType.DIE.getName();
    }

    @Override
    public String[] getSuggestedLoggingOption() {
        return LoggingType.LOGGING_SUGGESTIONS;
    }

    protected class_5250 getNameText(T entity) {
        return Messenger.tr(entity.method_5864().method_5882(), new Object[0]);
    }

    protected class_5250 getNameTextHoverText(T entity) {
        return null;
    }

    protected abstract boolean getAcceleratorBoolean();

    private class_5250 getNameTextRich(T entity) {
        class_5250 text = this.getNameText(entity);
        class_5250 hoverText = this.getNameTextHoverText(entity);
        if (hoverText != null) {
            Messenger.hover(text, hoverText);
        }
        return text;
    }

    private class_5250 getWorldTimeText(class_1937 world) {
        return Messenger.s((Object)String.format("[%s] ", WorldUtils.getWorldTime(world)), "g");
    }

    private void onLoggingEvent(T entity, LoggingType loggingType, Supplier<class_5250[]> supplier) {
        if (this.getAcceleratorBoolean() && EntityUtils.getEntityWorld(entity) != null && !EntityUtils.getEntityWorld(entity).method_8608()) {
            LoggerRegistry.getLogger((String)this.getName()).log(option -> loggingType.isContainedIn(option) ? (class_2561[])supplier.get() : null);
        }
    }

    public void onEntityCreated(T entity) {
        this.onLoggingEvent(entity, LoggingType.CREATE, () -> new class_5250[]{Messenger.c(this.getWorldTimeText(EntityUtils.getEntityWorld(entity)), translator.tr("created", this.getNameTextRich(entity)), "g  @ ", Messenger.coord("w", entity.method_73189(), DimensionWrapper.of(entity)), "w  ", StackTracePrinter.makeSymbol(this.getClass()))});
    }

    public void onEntityDespawn(T entity) {
        this.onLoggingEvent(entity, LoggingType.DESPAWN, () -> new class_5250[]{Messenger.c(this.getWorldTimeText(EntityUtils.getEntityWorld(entity)), translator.tr("despawned", this.getNameTextRich(entity)), "g  @ ", Messenger.coord("w", entity.method_73189(), DimensionWrapper.of(entity)))});
    }

    public void onEntityDied(T entity, class_1282 source, float amount) {
        this.onLoggingEvent(entity, LoggingType.DIE, () -> new class_5250[]{Messenger.c(this.getWorldTimeText(EntityUtils.getEntityWorld(entity)), Messenger.fancy(null, Messenger.tr("death.attack." + source.method_5525(), Messenger.formatting(this.getNameTextRich(entity), class_124.field_1068)), Messenger.c(translator.tr("damage_amount", "Damage amount"), String.format("w : %.1f", Float.valueOf(amount))), null), "g  @ ", Messenger.coord("w", entity.method_73189(), DimensionWrapper.of(entity)))});
    }

    public static enum LoggingType {
        DESPAWN,
        DIE,
        CREATE;

        public static final String[] LOGGING_SUGGESTIONS;

        public String getName() {
            return this.name().toLowerCase();
        }

        public boolean isContainedIn(String option) {
            return Arrays.asList(option.split("[,. ]")).contains(this.getName());
        }

        static {
            List<String> list = Arrays.stream(LoggingType.values()).map(LoggingType::getName).collect(Collectors.toList());
            list.add(EntityLogger.createCompoundOption(list));
            list.add(EntityLogger.createCompoundOption(Lists.newArrayList((Object[])new String[]{LoggingType.DESPAWN.getName(), LoggingType.DIE.getName()})));
            LOGGING_SUGGESTIONS = list.toArray(new String[0]);
        }
    }
}

