/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.info.entity;

import carpettisaddition.utils.ItemUtils;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;

public class EntityInfoUtil {
    public static String makeTime(long ticks) {
        long secs = ticks / 20L;
        if (secs < 60L) {
            return String.format("%d\"", secs);
        }
        if (secs < 3600L) {
            return String.format("%d'%d\"", secs / 60L, secs % 60L);
        }
        return String.format("%dh%d'%d\"", secs / 60L / 60L, secs % 3600L / 60L, secs % 3600L % 60L);
    }

    public static String display_item(class_1309 owner, class_1799 item) {
        String stackname;
        if (item == null) {
            return null;
        }
        if (item.method_7960()) {
            return null;
        }
        String string = stackname = item.method_7947() > 1 ? String.format("%dx%s", item.method_7947(), item.method_7964().getString()) : item.method_7964().getString();
        if (item.method_7986()) {
            int maxUseTime = item.method_7935();
            stackname = stackname + String.format(" %d/%d", maxUseTime - item.method_7919(), maxUseTime);
        }
        if (item.method_7942()) {
            stackname = stackname + " ( ";
            Map<class_1887, Integer> enchants = ItemUtils.getEnchantments(item);
            for (class_1887 e : enchants.keySet()) {
                int level = enchants.get(e);
                String enstring = e.method_8179(level).getString();
                stackname = stackname + enstring + " ";
            }
            stackname = stackname + ")";
        }
        return stackname;
    }

    public static String entity_short_string(class_1297 e) {
        if (e == null) {
            return "None";
        }
        return String.format("%s at [%.1f, %.1f, %.1f]", e.method_5476().getString(), e.field_5987, e.field_6010, e.field_6035);
    }

    public static double get_speed(double internal) {
        return 43.1 * internal;
    }

    public static double get_horse_speed_percent(double internal) {
        double min = 0.1125;
        double max = 0.3375;
        return 100.0 * (internal - min) / (max - min);
    }

    public static double get_horse_jump(double x) {
        return -0.1817584952 * x * x * x + 3.689713992 * x * x + 2.128599134 * x - 0.343930367;
    }

    public static double get_horse_jump_percent(double internal) {
        double min = 0.4;
        double max = 1.0;
        return 100.0 * (internal - min) / (max - min);
    }
}

